% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLreg.R
\name{sandwich}
\alias{sandwich}
\title{Sandwich Variance and Covariance Matrix for PLreg Objects}
\usage{
sandwich(object)
}
\arguments{
\item{object}{fitted model object of class "\code{PLreg}".}
}
\value{
\code{extra.parameter} returns a matrix containing the sandwich variance and
covariance matrix estimate.
}
\description{
The \code{sandwich} function provides an estimate for the asymptotic variance
and covariance matrix of the parameter estimators of the power logit (or log-log)
regression models based on de sandwich estimator (see Queiroz and Ferrari (2022)).
}
\examples{
data("Firm")

fit <- PLreg(percentfat ~ days + sex + year, data = bodyfat_Aeolus,
             family = "PE", zeta = 2)
sandwich(fit)
}
\references{
Queiroz, F. F. and Ferrari, S. L. P. (2022). Power logit regression
for modeling bounded data. \emph{arXiv}:2202.01697.
}
\seealso{
\code{\link{PLreg}}
}
