% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNfit-class.R
\name{PLNfit}
\alias{PLNfit}
\title{An R6 Class to represent a PLNfit in a standard, general framework}
\description{
The function \code{\link{PLN}} fit a model which is an instance of a object with class \code{PLNfit} .
Objects produced by the functions \code{\link{PLNnetwork}}, \code{\link{PLNPCA}} and \code{\link{PLNLDA}} also enjoy the method of \code{\link{PLNfit}}
by inheritance.

This class comes with a set of R6 methods, some of them being useful for the user and exported as S3 methods.
See the documentation for \code{\link[=coef.PLNfit]{coef}}, \code{\link[=sigma.PLNfit]{sigma.PLNfit}},
\code{\link[=predict.PLNfit]{predict}}, \code{\link[=vcov.PLNfit]{vcov}} and \code{\link[=standard_error.PLNfit]{standard_error}}.

Fields are accessed via active binding and cannot be changed by the user.
}
\examples{
\dontrun{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
myPLN <- PLN(Abundance ~ 1, data = trichoptera)
class(myPLN)
print(myPLN)
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{model}}{character: the model used for the coavariance (either "spherical", "diagonal" or "full")}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{model_par}}{a list with the matrices of parameters found in the model (Theta, Sigma, plus some others depending on the variant)}

\item{\code{var_par}}{a list with two matrices, M and S, which are the estimated parameters in the variational approximation}

\item{\code{latent}}{a matrix: values of the latent vector (Z in the model)}

\item{\code{optim_par}}{a list with parameters useful for monitoring the optimization}

\item{\code{model}}{character: the model used for the coavariance (either "spherical", "diagonal" or "full")}

\item{\code{loglik}}{variational lower bound of the loglikelihood}

\item{\code{loglik_vec}}{element-wise variational lower bound of the loglikelihood}

\item{\code{BIC}}{variational lower bound of the BIC}

\item{\code{ICL}}{variational lower bound of the ICL}

\item{\code{R_squared}}{approximated goodness-of-fit criterion}

\item{\code{nb_param}}{number of parameters in the current PLN model}

\item{\code{criteria}}{a vector with loglik, BIC, ICL, R_squared and number of parameters}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-update}{\code{PLNfit$update()}}
\item \href{#method-new}{\code{PLNfit$new()}}
\item \href{#method-optimize}{\code{PLNfit$optimize()}}
\item \href{#method-set_R2}{\code{PLNfit$set_R2()}}
\item \href{#method-postTreatment}{\code{PLNfit$postTreatment()}}
\item \href{#method-latent_pos}{\code{PLNfit$latent_pos()}}
\item \href{#method-VEstep}{\code{PLNfit$VEstep()}}
\item \href{#method-predict}{\code{PLNfit$predict()}}
\item \href{#method-compute_fisher}{\code{PLNfit$compute_fisher()}}
\item \href{#method-compute_standard_error}{\code{PLNfit$compute_standard_error()}}
\item \href{#method-show}{\code{PLNfit$show()}}
\item \href{#method-print}{\code{PLNfit$print()}}
\item \href{#method-clone}{\code{PLNfit$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update"></a>}}
\subsection{Method \code{update()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfit$update(
  Theta = NA,
  Sigma = NA,
  M = NA,
  S = NA,
  Ji = NA,
  R2 = NA,
  Z = NA,
  A = NA,
  monitoring = NA
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfit$new(responses, covariates, offsets, weights, model, control)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-optimize"></a>}}
\subsection{Method \code{optimize()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfit$optimize(responses, covariates, offsets, weights, control)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_R2"></a>}}
\subsection{Method \code{set_R2()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfit$set_R2(responses, covariates, offsets, weights, nullModel = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-postTreatment"></a>}}
\subsection{Method \code{postTreatment()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfit$postTreatment(
  responses,
  covariates,
  offsets,
  weights = rep(1, nrow(responses)),
  type = c("wald", "louis"),
  nullModel = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-latent_pos"></a>}}
\subsection{Method \code{latent_pos()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfit$latent_pos(covariates, offsets)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VEstep"></a>}}
\subsection{Method \code{VEstep()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfit$VEstep(X, O, Y, control = list())}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-predict"></a>}}
\subsection{Method \code{predict()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfit$predict(newdata, type = c("link", "response"), envir = parent.frame())}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-compute_fisher"></a>}}
\subsection{Method \code{compute_fisher()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfit$compute_fisher(type = c("wald", "louis"), X = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-compute_standard_error"></a>}}
\subsection{Method \code{compute_standard_error()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfit$compute_standard_error()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-show"></a>}}
\subsection{Method \code{show()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfit$show(
  model = paste("A multivariate Poisson Lognormal fit with", private$covariance,
    "covariance model.\\n")
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfit$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNfit$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
