% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNnetworkfit-class.R
\docType{data}
\name{PLNnetworkfit}
\alias{PLNnetworkfit}
\title{An R6 Class to represent a PLNfit in a sparse inverse covariance framework}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
PLNnetworkfit
}
\description{
The function \code{\link{PLNnetwork}} produces a collection of models which are instances of object with class \code{PLNnetworkfit}.

This class comes with a set of methods, some of them being useful for the user:
See the documentation for \code{\link[=plot.PLNnetworkfit]{plot.PLNnetworkfit}} + methods inherited from PLNfit.
}
\section{Fields}{

\describe{
\item{\code{penalty}}{the level of sparsity in the current model}

\item{\code{model_par}}{a list with the matrices associated with the estimated parameters of the pPCA model: Theta (covariates), Sigma (latent covariance) and Theta (latent precision matrix). Note Omega and Sigma are inverse of each other.}

\item{\code{var_par}}{a list with two matrices, M and S, which are the estimated parameters in the variational approximation}

\item{\code{latent}}{a matrix: values of the latent vector (Z in the model)}

\item{\code{optim_par}}{a list with parameters useful for monitoring the optimization}

\item{\code{loglik}}{variational lower bound of the loglikelihood}

\item{\code{pen_loglik}}{variational lower bound of the l1-penalized loglikelihood}

\item{\code{BIC}}{variational lower bound of the BIC}

\item{\code{EBIC}}{variational lower bound of the EBIC}

\item{\code{ICL}}{variational lower bound of the ICL}

\item{\code{R_squared}}{approximated goodness-of-fit criterion}

\item{\code{nb_param}}{number of parameters in the current PLN model}

\item{\code{density}}{proportion of non-null edges in the network}

\item{\code{criteria}}{a vector with loglik, BIC, ICL, R_squared and number of parameters}
}}

\examples{
\dontrun{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
nets <- PLNnetwork(Abundance ~ 1, data = trichoptera)
myPLNnet <- getBestModel(nets)
class(myPLNnet)
print(myPLNnet)
}
}
\seealso{
The function \code{\link{PLNnetwork}}, the class \code{\link[=PLNnetworkfamily]{PLNnetworkfamily}}
}
\keyword{datasets}
