% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNfit-class.R
\docType{data}
\name{PLNfit}
\alias{PLNfit}
\title{An R6 Class to represent a PLNfit in a standard, general framework}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
PLNfit
}
\description{
The function \code{\link{PLN}} fit a model which is an instance of a object with class \code{PLNfit} .
Objects produced by the functions \code{\link{PLNnetwork}}, \code{\link{PLNPCA}} and \code{\link{PLNLDA}} also enjoy the method of \code{\link{PLNfit}}
by inheritance.

This class comes with a set of R6 methods, some of them being useful for the user and exported as S3 methods.
See the documentation for \code{\link[=coef.PLNfit]{coef}}, \code{\link[=sigma.PLNfit]{sigma.PLNfit}},
\code{\link[=predict.PLNfit]{predict}}, \code{\link[=vcov.PLNfit]{vcov}} and \code{\link[=standard_error.PLNfit]{standard_error}}.

Fields are accessed via active binding and cannot be changed by the user.
}
\section{Fields}{

\describe{
\item{\code{model_par}}{a list with the matrices of parameters found in the model (Theta, Sigma, plus some others depending on the variant)}

\item{\code{var_par}}{a list with two matrices, M and S, which are the estimated parameters in the variational approximation}

\item{\code{latent}}{a matrix: values of the latent vector (Z in the model)}

\item{\code{optim_par}}{a list with parameters useful for monitoring the optimization}

\item{\code{model}}{character: the model used for the coavariance (either "spherical", "diagonal" or "full")}

\item{\code{loglik}}{variational lower bound of the loglikelihood}

\item{\code{loglik_vec}}{element-wise variational lower bound of the loglikelihood}

\item{\code{BIC}}{variational lower bound of the BIC}

\item{\code{ICL}}{variational lower bound of the ICL}

\item{\code{R_squared}}{approximated goodness-of-fit criterion}

\item{\code{nb_param}}{number of parameters in the current PLN model}

\item{\code{criteria}}{a vector with loglik, BIC, ICL, R_squared and number of parameters}
}}

\examples{
\dontrun{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
myPLN <- PLN(Abundance ~ 1, data = trichoptera)
class(myPLN)
print(myPLN)
}
}
\keyword{datasets}
