% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNnetworkfamily-S3methods.R
\name{coefficient_path}
\alias{coefficient_path}
\title{Extract the regularization path of a PLNnetwork fit}
\usage{
coefficient_path(Robject, precision = TRUE, corr = TRUE)
}
\arguments{
\item{Robject}{an object with class \code{\link{PLNnetworkfamily}}, i.e. an output from \code{\link[=PLNnetwork]{PLNnetwork()}}}

\item{precision}{a logical, should the coefficients of the precision matrix Omega or the covariance matrix Sigma be sent back. Default is \code{TRUE}.}

\item{corr}{a logical, should the correlation (partial in case  \code{precision = TRUE}) be sent back. Default is \code{TRUE}.}
}
\value{
Sends back a tibble/data.frame.
}
\description{
Extract the regularization path of a PLNnetwork fit
}
\examples{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
fits <- PLNnetwork(Abundance ~ 1, data = trichoptera)
head(coefficient_path(fits))
}
