% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLMIXfunctions.R
\name{print.gsPLMIX}
\alias{print.gsPLMIX}
\title{Print of the Gibbs sampling simulation of a Bayesian mixture of Plackett-Luce models}
\usage{
\method{print}{gsPLMIX}(x, ...)
}
\arguments{
\item{x}{Object of class \code{gsPLMIX} returned by the \code{gibbsPLMIX} function.}

\item{...}{Further arguments passed to or from other methods (not used).}
}
\description{
\code{print} method for class \code{gsPLMIX}. It shows some general information on the Gibbs sampling simulation for a Bayesian mixture of Plackett-Luce models.
}
\examples{

## Print of the Gibbs sampling procedure
data(d_carconf)
GIBBS <- gibbsPLMIX(pi_inv=d_carconf, K=ncol(d_carconf), G=3, n_iter=30, n_burn=10)
print(GIBBS)
}
\seealso{
\code{\link{gibbsPLMIX}}
}
\author{
Cristina Mollica and Luca Tardella
}
