% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLMIXfunctions.R, R/RcppExports.R
\name{Loglikelihood}
\alias{Loglikelihood}
\alias{likPLMIX}
\alias{loglikPLMIX}
\alias{loglikelihood}
\alias{Likelihood}
\alias{likelihood}
\alias{loglikPLMIX}
\title{Likelihood and Log-likelihood evaluation for a mixture of Plackett-Luce models}
\usage{
likPLMIX(p, ref_order, weights, pi_inv)

loglikPLMIX(p, ref_order, weights, pi_inv)
}
\arguments{
\item{p}{Numeric \eqn{G}\eqn{\times}{x}\eqn{K} matrix of component-specific support parameters.}

\item{ref_order}{Numeric \eqn{G}\eqn{\times}{x}\eqn{K} matrix of component-specific reference orders.}

\item{weights}{Numeric vector of \eqn{G} mixture weights.}

\item{pi_inv}{Numeric \eqn{N}\eqn{\times}{x}\eqn{K} data matrix of partial orderings.}
}
\value{
Either the likelihood or the log-likelihood value of the Plackett-Luce mixture model parameters for a partial ordering dataset.
}
\description{
Compute either the likelihood or the log-likelihood of the Plackett-Luce mixture model parameters for a partial ordering dataset.
}
\details{
The \code{ref_order} argument accommodates for the more general mixture of Extended Plackett-Luce models (EPL), involving the additional reference order parameters (Mollica and Tardella 2014). A permutation of the first \eqn{K} integers can be specified in each row of the \code{ref_order} argument. Since the Plackett-Luce model is a special instance of the EPL with the reference order equal to the identity permutation, the \code{ref_order} argument must be a matrix with \eqn{G} rows equal to \eqn{(1,\dots,K)} when dealing with Plackett-Luce mixtures.
}
\examples{

data(d_apa)

K <- ncol(d_apa)
G <- 3
support_par <- matrix(1:(G*K), nrow=G, ncol=K)
weights_par <- c(0.50, 0.25, 0.25)

loglikPLMIX(p=support_par, ref_order=matrix(1:K, nrow=G, ncol=K, byrow=TRUE), 
            weights=weights_par, pi_inv=d_apa)

}
\references{
Mollica, C. and Tardella, L. (2017). Bayesian Plackett-Luce mixture models for partially ranked data. \emph{Psychometrika}, \bold{82}(2), pages 442--458, ISSN: 0033-3123, DOI: 10.1007/s11336-016-9530-0.

Mollica, C. and Tardella, L. (2014). Epitope profiling via mixture modeling for ranked data. \emph{Statistics in Medicine}, \bold{33}(21), pages 3738--3758, ISSN: 0277-6715, DOI: 10.1002/sim.6224.
}
\author{
Cristina Mollica and Luca Tardella
}
