% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCMTree.R
\name{PCMTreeBackbonePartition}
\alias{PCMTreeBackbonePartition}
\title{Prune the tree leaving one tip for each or some of its parts}
\usage{
PCMTreeBackbonePartition(tree, partsToKeep = PCMTreeGetPartNames(tree))
}
\arguments{
\item{tree}{a PCMTree or a phylo object.}

\item{partsToKeep}{a character vector denoting part names in the tree to be
kept. Defaults to `PCMTreeGetPartNames(tree)`.}
}
\value{
a PCMTree object representing a pruned version of tree.
}
\description{
Prune the tree leaving one tip for each or some of its parts
}
\examples{
set.seed(1, kind = "Mersenne-Twister", normal.kind = "Inversion")
tree <- PCMTree(ape::rtree(25))

if(requireNamespace("ggtree"))
PCMTreePlot(tree) + ggtree::geom_nodelab(angle = 45) +
  ggtree::geom_tiplab(angle = 45)

backb <-  PCMTreeBackbonePartition(tree)

if(requireNamespace("ggtree"))
PCMTreePlot(backb) + ggtree::geom_nodelab(angle = 45) +
  ggtree::geom_tiplab(angle = 45)

tree2 <- PCMTreeSetPartRegimes(
  tree, c(`26` = "a", `28` = "b"), setPartition = TRUE,
  inplace = FALSE)

if(requireNamespace("ggtree"))
PCMTreePlot(tree2) + ggtree::geom_nodelab(angle = 45) +
  ggtree::geom_tiplab(angle = 45)

backb <-  PCMTreeBackbonePartition(tree2)

if(requireNamespace("ggtree"))
PCMTreePlot(backb) + ggtree::geom_nodelab(angle = 45) +
  ggtree::geom_tiplab(angle = 45)

tree3 <- PCMTreeSetPartRegimes(
  tree, c(`26` = "a", `28` = "b", `41` = "c"), setPartition = TRUE,
  inplace = FALSE)

if(requireNamespace("ggtree"))
PCMTreePlot(tree3) + ggtree::geom_nodelab(angle = 45) +
  ggtree::geom_tiplab(angle = 45)

backb <-  PCMTreeBackbonePartition(tree3)

if(requireNamespace("ggtree"))
PCMTreePlot(backb) + ggtree::geom_nodelab(angle = 45) +
  ggtree::geom_tiplab(angle = 45)

backb41 <-  PCMTreeBackbonePartition(tree3, partsToKeep = "41")

if(requireNamespace("ggtree"))
PCMTreePlot(backb41) + ggtree::geom_nodelab(angle = 45) +
  ggtree::geom_tiplab(angle = 45)

backbMoreNodes <- PCMTreeInsertSingletonsAtEpoch(
   backb, epoch = 3.7, minLength = 0.001)
PCMTreeGetPartRegimes(backbMoreNodes)

if(requireNamespace("ggtree"))
PCMTreePlot(backbMoreNodes) + ggtree::geom_nodelab(angle=45) +
  ggtree::geom_tiplab(angle=45)

backbMoreNodes <- PCMTreeInsertSingletonsAtEpoch(
   backbMoreNodes, epoch = 0.2, minLength = 0.001)
PCMTreeGetPartRegimes(backbMoreNodes)

if(requireNamespace("ggtree"))
PCMTreePlot(backbMoreNodes) + ggtree::geom_nodelab(angle=45) +
  ggtree::geom_tiplab(angle=45)

backbMoreNodes <- PCMTreeInsertSingletonsAtEpoch(
   backbMoreNodes, epoch = 1.2, minLength = 0.001)
PCMTreeGetPartRegimes(backbMoreNodes)

if(requireNamespace("ggtree"))
PCMTreePlot(backbMoreNodes) + ggtree::geom_nodelab(angle=45) +
  ggtree::geom_tiplab(angle=45)

}
\seealso{
PCMTreeSetPartition

PCMTree
}
