% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_BMI_percentile_helpers.R
\name{bmi_internal}
\alias{bmi_internal}
\alias{percentile_age}
\alias{percentile_BMI}
\alias{percentile_index}
\alias{percentile_lms}
\alias{percentile_reference}
\alias{percentile_sex}
\alias{percentile_z}
\alias{percentile_back_calculate}
\title{Internal helper functions for \code{\link{get_BMI_percentile}}}
\usage{
percentile_age(age_mos, age_yrs)

percentile_BMI(BMI, weight_kg, height_cm)

percentile_index(reference, age_mos)

percentile_lms(reference, colname, lesser_index, greater_index, increment)

percentile_reference(sex)

percentile_sex(sex = c("error", "male", "female"))

percentile_z(BMI, L, M, S)

percentile_back_calculate(p = 0.95, L, M, S)
}
\arguments{
\item{age_mos}{age in months (optional)}

\item{age_yrs}{age in years}

\item{BMI}{numeric. Body mass index}

\item{weight_kg}{Weight in kilograms}

\item{height_cm}{height in centimeters}

\item{reference}{reference subset for calculations}

\item{colname}{character. Column name of \code{reference} on which to operate}

\item{lesser_index}{lower match index of \code{reference}}

\item{greater_index}{upper match index of \code{reference}}

\item{increment}{proportional distance between
\code{reference[lesser_index, ]} and \code{reference[greater_index, ]}}

\item{sex}{Character scalar indicating participant's sex}

\item{L}{lambda}

\item{M}{mu}

\item{S}{sigma}

\item{p}{percentile for which to back-calculate a BMI (must be between 0 and
1)}
}
\description{
Internal helper functions for \code{\link{get_BMI_percentile}}
}
\seealso{
\href{https://pubmed.ncbi.nlm.nih.gov/24992748/}{Flegal and Cole (2013)}
}
\keyword{internal}
