% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot}
\alias{plot}
\alias{plot.PAsso}
\title{A matrix of partial regression plots between responses after adjustments}
\usage{
\method{plot}{PAsso}(x, color = "#444444", shape = 19, size = 2, alpha = 0.5, ...)
}
\arguments{
\item{x}{The object in "PAsso" class that is generated by "PAsso" or "test".}

\item{color}{The color of points.}

\item{shape}{The shapre of points. For more details see the help vignette:
\code{vignette("ggplot2-specs", package = "ggplot2")}}

\item{size}{The size of points. For more details see the help vignette:
\code{vignette("ggplot2-specs", package = "ggplot2")}}

\item{alpha}{The value to make the points transparent. For more details see the help vignette:
\code{vignette("ggplot2-specs", package = "ggplot2")}}

\item{...}{Additional optional arguments to be passed onto.}
}
\value{
A \code{"GGally"} object.
}
\description{
A plot matrix to display the results of partial association analyses.
Upper-triangle contains scatter-plot matrix between each pair of response variables.
Lower-triangle contains the partial correlation coefficients adjusted by covariates.
}
\details{
A pairwise plot matrix reveals the partial association between ordinal variables.
All the plots are based on surrogate residuals generated from \code{"resides"} function.
Graphics are designed based on \code{\link{ggplot2}} and \code{"GGally"}.
}
\examples{
data(ANES2016)

summary(ANES2016)

PAsso_2v <- PAsso(responses = c("PreVote.num", "PID"),
                 adjustments = c("income.num", "age", "edu.year"),
                 data = ANES2016)

plot(PAsso_2v)

}
