% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MVPA_summary.R
\name{MVPA_summary}
\alias{MVPA_summary}
\title{Activity Summary--MVPA}
\usage{
MVPA_summary(final_dat)
}
\arguments{
\item{final_dat}{cleaned final data that is between record getup time and sleep time}
}
\value{
\code{Total_light_time} Total light time: the total activity minutes minus the total MVPA hours

\code{Total_MVPA_time}  Total MVPA hours: the summation of the total Long Bout MVPA and total Sporadic MVPA durations

\code{Total_MVPA_Long_Bout_time} Total MVPA long bout time: the summation of the total Long Bout MVPA durations

\code{Total_mvpa_sporadic_time} Total MVPA sporadic time: the summation of the total Sporadic MVPA durations

\code{Total_Number_of_MVPA_Long_Bouts_and_Sporadic} Total Number of MVPA (Long Bouts or Sporadic): count the number of MVPA from 15 second data

\code{Proportion_of_MVPA_Long_Bouts_and_Sporadic_greater_2} Proportion of MVPA (Long Bouts or Sporadic) greater than 2 minutes

\code{Proportion_of_MVPA_Long_Bouts_and_Sporadic_greater_5} Proportion of MVPA (Long Bouts or Sporadic) greater than 5 minutes

\code{Proportion_of_MVPA_Long_Bouts_and_Sporadic_greater_10} Proportion of MVPA (Long Bouts or Sporadic) greater than 10 minutes

\code{Total_Number_of_MVPA_Long_Bouts} Total number of long bout MVPA: count the number of Long Bouts MVPA from 10 minute data

\code{Mean_MVPA_Long_Bout_Length} Mean of long bout MVPA length

\code{Proportion_of_MVPA_Long_Bouts_greater_10} Proportion of Long Bout MVPA greater than 10 minutes

\code{Proportion_of_MVPA_Long_Bouts_greater_20} Proportion of Long Bout MVPA greater than 20 minutes

\code{Highest_MET_value_15s} Highest METs values in 15 second

\code{Highest_MET_value_10min} Highest METs values in 10 minutes

\code{Total_MET_hrs_Long_Bouts_and_Sporadic_mvpa} Total METs hours from Long Bout MVPA and sporadic MVPA: the summation of METs hours from all MVPA records

\code{Total_MET_hrs_Long_Bouts} Total METs hours from Long Bout MVPA: the summation of METs hours from Long Bout MVPA records
}
\description{
Summarize activity measures using MVPA
}
\details{
MVPA is defined into two types: Long Bout MVPA and Sporadic MVPA_ Long Bout MVPA is defined as 10 consecutive minutes with METs>=3 (allowing 2 min below that threshold). Sporadic MVPA is defined as activities at any time with METS>=3 and they are not in Long Bout MVPA.

Highest METs values in 15 second/10 minutes are calculated by picking up the maximum METs values from the combined data with 15 second intervals and the data with 10 minutes intervals, respectively.
}
\examples{
data(sampledata);MVPA_summary(sampledata)
}

