% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchGFS.R
\name{matchGFS}
\alias{matchGFS}
\title{Match GFS Environmental Data}
\usage{
matchGFS(x)
}
\arguments{
\item{x}{a dataframe with columns \code{UTC}, \code{Latitude} and
\code{Longitude} to add environmental data to}
}
\value{
a dataframe with wind and precipitation rate columns added
}
\description{
Downloads and matches wind and precipitation data
from the Global Forecast System (GFS) weather model. Data is
downloaded from the National Center for Atmospheric Research
data server \url{https://rda.ucar.edu/datasets/ds084.1/}
}
\examples{
gps <- data.frame(Latitude=c(33.2, 33.5,33.6),
                  Longitude=c(-118.1, -118.4, -119),
                  UTC=as.POSIXct(
                    c('2022-04-28 05:00:00',
                      '2022-04-28 10:00:00',
                      '2022-04-28 20:00:00'), tz='UTC'))
gps <- matchGFS(gps)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
