% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addAnnotation.R
\name{addAnnotation}
\alias{addAnnotation}
\alias{prepAnnotation}
\alias{getAnnotation}
\alias{checkAnnotation}
\alias{export_annomate}
\alias{matchRecordingUrl}
\title{Add Annotation Data to an AcousticStudy Object}
\usage{
addAnnotation(x, anno, verbose = TRUE)

prepAnnotation(
  x,
  specMap = NULL,
  mode = c("event", "detection"),
  interactive = FALSE,
  ...
)

getAnnotation(x)

checkAnnotation(x)

export_annomate(x, file = NULL)

matchRecordingUrl(anno, rec)
}
\arguments{
\item{x}{an \linkS4class{AcousticStudy} or \linkS4class{AcousticEvent} object}

\item{anno}{an annotation dataframe}

\item{verbose}{logical flag to print messages}

\item{specMap}{data.frame to map species ids in \code{x} to names to be used
for the annotation (ex. from \code{'ZC'} to \code{'Ziphius cavirostris'}.
Dataframe must have columns \code{old} and \code{new}}

\item{mode}{one of \code{'event'} or \code{'detection'} to create annotation for
events or detections}

\item{interactive}{logical flag to fill annotation data interactively
(not recommended)}

\item{\dots}{additional named arguments to fill in annotation data. If names match
a column in the annotation, that value will be used for all events or detections
in the annotation}

\item{file}{file to write a CSV of the annotations to, if \code{NULL} (default)
then no file will be written}

\item{rec}{dataframe of recording url information. Must have column
\code{recording_url}. If clips were created using \link[PAMpal]{writeEventClips},
then must have column \code{filename} containing the wav file names. Other
column names will be automatically parsed from there. If wav files are from
another source, must contain columns \code{matchId}}
}
\value{
The same object as \code{x} with an \code{$annotation} item added
  the the \code{ancillary} slot of each event in \code{x}
}
\description{
Adds annotation data to an \linkS4class{AcousticStudy}
  object, usually in preparation for exporting to an external source.
  Most pieces of the annotation form will be filled in by the user when
  the function is called, but \code{lat}, \code{lon}, \code{time_start},
  \code{time_end}, \code{freq_low}, \code{freq_high}, \code{source_id},
  and \code{annotation_id} will be filled in automatically based on data
  in each \linkS4class{AcousticEvent}. Annotations are stored for each
  event in the \code{ancillary} slot.
}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
