% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPresGrid.R
\name{plotPresGrid}
\alias{plotPresGrid}
\title{plotPresGrid}
\usage{
plotPresGrid(
  x,
  start = NULL,
  end = NULL,
  timeBin = c("hour", "minute", "30min", "15min"),
  type = c("presence", "density"),
  gps = NULL,
  format = c("\%m/\%d/\%Y \%H:\%M:\%S", "\%m-\%d-\%Y \%H:\%M:\%S",
    "\%Y/\%m/\%d \%H:\%M:\%S", "\%Y-\%m-\%d \%H:\%M:\%S"),
  fill = "blue",
  color = NA,
  cmap = viridis(25),
  title = TRUE
)
}
\arguments{
\item{x}{a data.frame of detections, must have a column \code{UTC} that contains the
time of detection as a POSIXct object in UTC timezone}

\item{start}{the beginning datetime of the plot, if \code{NULL} will be set to the minimum
time in \code{x}}

\item{end}{the ending datetime of the plot, if \code{NULL} will be set to the maximum
time in \code{x}}

\item{timeBin}{the unit of time for each rectangle in the grid, must be one of "hour", "minute",
"30min", or "15min"}

\item{type}{one of either "presence" or "density". If "density", then boxes will be colored according
to the number of detections in each \code{timeBin} will be plotted. If "presence", then each box
will be colored by \code{fill}}

\item{gps}{(optional) if not \code{NULL}, a data.frame of GPS coordinates covering the date range
of \code{x}. These are used to calculate sunrise and sunset information which is shown as a
shaded dark region in the background of the plot. The data.frame must have columns "UTC",
"Latitude", and "Longitude". If columns "Latitude" and "Longitude" are present in \code{x},
then these values will be used and you do not need to provide separate GPS data here}

\item{format}{date format if \code{UTC} column of \code{x} is a character}

\item{fill}{the fill color for the boxes, only used if \code{type} is "presence"}

\item{color}{the outline color for the boxes, only used if \code{type} is "presence"}

\item{cmap}{the colormap to use for the boxes, only used if \code{type} is "density"}

\item{title}{if \code{TRUE}, a title will automatically created. If any other value, that will be
used for the title of the plot.}
}
\value{
a ggplot2 object
}
\description{
Creates a grid plot of the presence or density of detections across time
  where the x-axis is the hour of the day and the y-axis is the date
}
\examples{

df <- data.frame(UTC = as.POSIXct(runif(1e2, min=0, max=7*24*3600),
                                  origin='1970-01-01 00:00:00', tz='UTC'))
plotPresGrid(df, type='presence', timeBin='hour')
plotPresGrid(df, type='density', timeBin='hour')
plotPresGrid(df, type='density', timeBin='30min')
gps <- data.frame(UTC = as.POSIXct('1970-01-01 00:00:00', tz='UTC'),
                 Latitude=32.4,
                 Longitude = -118)
plotPresGrid(df, gps=gps, timeBin='hour')

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
