% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metapafway.R
\name{pafway_meta}
\alias{pafway_meta}
\title{Compare the frequency of observed edges of a specific type and the expected frequency of these edges, given the presence of a different edge type}
\usage{
pafway_meta(GO, edges, GOtypes)
}
\arguments{
\item{GO}{A vector of Strings, equal to the length of all the nodes.  The names of the vector should be the names of the nodes.  The values should either be the functional annotations, or a concatenation of the functional annotations, separated by a "_" symbol.}

\item{edges}{A matrix of Strings, with at least two columns.  Each row will represent an edge, linking the node in the first column to the node in the second column.  Please make sure the node names are the same as those in "GO"}

\item{GOtypes}{This is a vector that contains the functional annotations or GO terms that are of interest}
}
\value{
A matrix that has the same number of rows and columns as length(GOtypes)*length(GOtypes).  The value at position [i,j] will contain ratio between the observed and expected frequency of edges of type i, based on the frequency of edges of type j.
}
\description{
Compare the frequency of observed edges of a specific type and the expected frequency of these edges, given the presence of a different edge type
}
\examples{
GO=c(rep('A,C', 5), rep('A', 5), rep('C', 5), rep('B,D', 5), rep('B', 5), rep('D', 5))
names(GO)=paste("node", 1:length(GO))
edges=cbind(names(GO)[1:(length(GO)/2)], names(GO)[(length(GO)/2+1):length(GO)])
GOtypes=c('A', "B", "C", "D")
pafway_meta(GO, edges, GOtypes)
}
