
.CreateDataCV_new <- function(net                   , p          = 0.75 , g           = 50, 
                              net_type = "directed" , deg_thresh = 0    , exclude_end = FALSE) {
  net               <- net[order(net[,3] , decreasing = FALSE),]
  time_stamp        <- as.vector(net[,3])
  in_node           <- as.vector(net[,2])
  out_node          <- as.vector(net[,1])
  node_id           <- sort(union(in_node,out_node))
  names(node_id)    <- node_id
  unique_time       <- sort(unique(time_stamp))
  T                 <- length(unique_time)
  N                 <- length(node_id) 
  appear            <- rep(0 , N)
  names(appear)     <- node_id
  first_time        <- time_stamp[1]
  edge_cumsum       <- cumsum(as.vector(table(time_stamp[time_stamp != first_time]))) 
  edge_ratio        <- edge_cumsum/edge_cumsum[length(edge_cumsum)]
  use_time          <- unique_time[which(edge_ratio >= p)[1]]
  
  data_new          <- net[time_stamp <= use_time, ]
  stats             <- get_statistics(data_new , net_type = net_type, 
                                     binning = TRUE , g = g , deg_threshold = deg_thresh)
  final_stat        <- get_statistics(net, binning = TRUE, g = g, net_type = net_type, deg_threshold = 0)
  
  appear[as.character(stats$f_position)] <- 1
  deg                                    <- stats$final_deg[as.character(stats$f_position)]
  
  if (FALSE == exclude_end) {
    if (net_type == "directed") {
      prob_em_each               <- matrix(0 , nrow = sum(unique_time > use_time) , ncol = length(final_stat$f_position))
      colnames(prob_em_each)     <- final_stat$f_position
      m_each                     <- rep(0 , sum(unique_time > use_time))
      deg_each                   <- matrix(-1 , nrow = sum(unique_time > use_time) , ncol = length(final_stat$f_position))
      colnames(deg_each)         <- final_stat$f_position
      
      deg_each[1,as.character(stats$f_position)] <- deg
      time_each                                  <- unique_time[unique_time > use_time]
      for (i in 1:length(time_each)){
        new_links                            <- in_node[time_stamp == time_each[i]]
        # get only the links to existing nodes
        new_links                            <- new_links[appear[as.character(new_links)] == 1]
        m_each[i]                            <- length(new_links)
        aaa                                  <- table(new_links)
        prob_em_each[i , labels(aaa)[[1]]]   <- aaa
        prob_em_each[i , labels(aaa)[[1]]]   <- prob_em_each[i,labels(aaa)[[1]]]/ m_each[i] 
        if (i < length(time_each)) {
          
          deg_each[i + 1,]                     <- deg_each[i,];    
          deg_each[i + 1,labels(aaa)[[1]]]     <- deg_each[i + 1 , labels(aaa)[[1]]] + aaa
          
          # updating the degree of newly added nodes in this time-step
          
          # first get the list of all new nodes
          all_nodes           <- unique(c(in_node[time_stamp == time_each[i]], out_node[time_stamp == time_each[i]])) 
          new_nodes           <- all_nodes[appear[as.character(all_nodes)] == 0]
          
          # set the initial degree of the new nodes to 0
          deg_each[i + 1, as.character(new_nodes)] <- 0
          # then counting the degrees of these new nodes
          not_count_new_links <- new_links[appear[as.character(new_links)] == 0]
          bbb                 <- table(not_count_new_links)
          deg_each[i + 1, labels(bbb)[[1]]] <- bbb
          # updating the list of existing nodes
          appear[as.character(new_nodes)]   <- 1
        } 
      }
    } else { #undirected network
      prob_em_each              <- matrix(0,nrow = sum(unique_time > use_time),ncol = length(stats$f_position))
      colnames(prob_em_each)    <- stats$f_position
      m_each                    <- rep(0,sum(unique_time > use_time))
      deg_each                  <- matrix(0,nrow = sum(unique_time > use_time),ncol = length(stats$f_position))
      colnames(deg_each)        <- stats$f_position
      deg_each[1,]              <- deg
      time_each                 <- unique_time[unique_time > use_time]
      for (i in 1:length(time_each)){
        new_in_links      <- in_node[time_stamp == time_each[i]]
        new_in_links      <- new_in_links[appear[as.character(new_in_links)] == 1]
        new_out_links     <- out_node[time_stamp == time_each[i]]
        new_out_links     <- new_out_links[appear[as.character(new_out_links)] == 1]
        m_each[i]         <- length(c(new_in_links,new_out_links))
        aaa               <- table(c(new_in_links,new_out_links))
        prob_em_each[i,labels(aaa)[[1]]] <- aaa
        prob_em_each[i,labels(aaa)[[1]]] <- prob_em_each[i,labels(aaa)[[1]]]/ m_each[i] 
        if (i < length(time_each)) {
          deg_each[i+1,]                 <- deg_each[i,];    
          deg_each[i+1,labels(aaa)[[1]]] <- deg_each[i+1,labels(aaa)[[1]]] + aaa
        }
      }
      
    }
    result            <- list(stats        = stats       , deg_each = deg_each,
                              m_each       = m_each      , p        = p       ,
                              prob_em_each = prob_em_each, use_time = use_time)
    class(result)     <- "CV_Data"
    return(result)
  } 
}


