% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertOMLTaskToMlr.R
\name{convertOMLTaskToMlr}
\alias{convertOMLTaskToMlr}
\title{Convert an OpenML task to mlr.}
\usage{
convertOMLTaskToMlr(obj, measures = NULL, mlr.task.id = "<oml.data.name>",
  ignore.flagged.attributes = TRUE, drop.levels = TRUE, verbosity = NULL)
}
\arguments{
\item{obj}{[\code{\link{OMLTask}}]\cr
The OML task object that should be converted.}

\item{measures}{[\code{\link[mlr]{Measure}}]\cr
Additional measures that should be computed.}

\item{mlr.task.id}{[\code{character(1)}]\cr
Id string for \code{\link[mlr]{Task}} object.
The strings \code{<oml.data.name>}, \code{<oml.data.id>}, \code{<oml.data.version>}
and \code{<oml.task.id>} will be replaced by their respective values contained
in the \code{\link{OMLTask}} object.
Default is \code{<oml.data.name>}.}

\item{ignore.flagged.attributes}{[\code{logical(1)}]\cr
Should those features that are listed in the data set description slot \dQuote{ignore.attribute}
be removed?
Default is \code{TRUE}.}

\item{drop.levels}{[\code{logical(1)}]\cr
Should empty factor levels be dropped in the data?
Default is \code{TRUE}.}

\item{verbosity}{[\code{integer(1)}]\cr
Print verbose output on console? Possible values are:\cr
\code{0}: normal output,\cr
\code{1}: info output,\cr
\code{2}: debug output.\cr
Default is set via \code{\link{setOMLConfig}}.}
}
\value{
[list] A list with the following objects:
\describe{
  \item{mlr.task}{[\code{\link[mlr]{Task}}]}
  \item{mlr.rin}{[\code{\link[mlr]{ResampleInstance}}]}
  \item{mlr.measures}{[list of \code{\link[mlr]{Measure}s} to optimize for.}
}
}
\description{
Converts an \code{\link{OMLTask}} to a list of \code{\link[mlr]{Task}},
\code{\link[mlr]{ResampleInstance}} and \code{\link[mlr]{Measure}}.
}
\examples{
# \dontrun{
# 	library("mlr")
# 	vinnieOML = getOMLTask(task.id = 4845)
# 	vinnieMlr = convertOMLTaskToMlr(vinnieOML)
# }
}
\seealso{
Other task-related functions: \code{\link{deleteOMLObject}},
  \code{\link{getOMLTask}}, \code{\link{listOMLTaskTypes}},
  \code{\link{listOMLTasks}}, \code{\link{makeOMLTask}},
  \code{\link{tagOMLObject}}
}
