% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getOMLDataSet.R
\name{getOMLDataSet}
\alias{getOMLDataSet}
\title{Get an OpenML data set.}
\usage{
getOMLDataSet(data.id = NULL, data.name = NULL, data.version = NULL,
  cache.only = FALSE, verbosity = NULL)
}
\arguments{
\item{data.id}{[\code{integer(1)}]\cr
ID of the data set.}

\item{data.name}{[\code{character(1)}]\cr
Data set name.
This is an alternative to \code{data.id}.
Default is \code{NULL}.}

\item{data.version}{[\code{integer(1)}]\cr
Version number of the data set with name \code{data.name}.
Default is \code{NULL}.
Ignored if \code{data.id} is passed.}

\item{cache.only}{[\code{logical(1)}]\cr
Only try to retrieve the object from cache.
Will result in error if the object is not found.
Default is \code{FALSE}.}

\item{verbosity}{[\code{integer(1)}]\cr
Print verbose output on console? Possible values are:\cr
\code{0}: normal output,\cr
\code{1}: info output,\cr
\code{2}: debug output.\cr
Default is set via \code{\link{setOMLConfig}}.}
}
\value{
[\code{\link{OMLDataSet}}].
}
\description{
Given a data set ID, the corresponding \code{\link{OMLDataSet}}
will be downloaded (if not in cache) and returned.

Note that data splits and other task-related information are not included in
an \code{\link{OMLDataSet}}. Tasks can be downloaded with \code{\link{getOMLTask}}.
}
\note{
One of \code{data.id} or \code{data.name} must be passed.
}
\examples{
\dontrun{
	dat = getOMLDataSet(data.id = 9)

	# this object contains the data ($data)
	# and meta information
	str(dat, 1)
	summary(dat$data)
}
}
\seealso{
Other downloading functions: \code{\link{getOMLDataSetQualities}},
  \code{\link{getOMLFlow}}, \code{\link{getOMLRun}},
  \code{\link{getOMLTask}}

Other data set-related functions: \code{\link{OMLDataSetDescription}},
  \code{\link{OMLDataSet}},
  \code{\link{convertMlrTaskToOMLDataSet}},
  \code{\link{convertOMLDataSetToMlr}},
  \code{\link{deleteOMLObject}},
  \code{\link{listOMLDataSets}},
  \code{\link{tagOMLObject}},
  \code{\link{uploadOMLDataSet}}
}
