% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otherplots.R
\name{netgrossplot}
\alias{netgrossplot}
\title{Net and gross changes of LUC categories}
\usage{
netgrossplot(
  dataset,
  legendtable,
  title = NULL,
  xlab = "LUC category",
  ylab = "Area (Km2)",
  legend_title = "Changes",
  changesLabel = c(GC = "Gross change", NG = "Net gain", NL = "Net loss"),
  color = c(GC = "gray70", NG = "#006400", NL = "#EE2C2C"),
  area_km2 = TRUE
)
}
\arguments{
\item{dataset}{A table of the multi step transition (\code{lulc_Mulstistep})
generated by \code{\link{contingencyTable}}.}

\item{legendtable}{A table containing the LUC legend items and their respective
color (\code{tb_legend}).}

\item{title}{character. The title of the plot (optional), use \code{NULL} for
no title.}

\item{xlab}{character. Label for the x axis.}

\item{ylab}{character. Label for the y axis.}

\item{legend_title}{character. The title of the legend.}

\item{changesLabel}{character. Labels for the three types of changes, defaults
are c(GC = "Gross change", NG = "Net gain", NL = "Net loss").}

\item{color}{character. A vector defining the three bar colors.}

\item{area_km2}{logical. If TRUE the change is computed in km2, if FALSE in
pixel counts.}
}
\value{
A bar plot
}
\description{
A stacked barplot showing net and gross changes of LUC categories during the
entire analysed time period.
}
\examples{

# editing the category names

SL_2002_2014$tb_legend$categoryName <- factor(c("Ap", "FF", "SA", "SG", "aa", "SF",
                                             "Agua", "Iu", "Ac", "R", "Im"),
                                     levels = c("FF", "SF", "SA", "SG", "aa", "Ap",
                                              "Ac", "Im", "Iu", "Agua", "R"))

# the plot
netgrossplot(dataset = SL_2002_2014$lulc_Multistep,
             legendtable = SL_2002_2014$tb_legend,
             title = NULL,
             xlab = "LUC Category",
             changes = c(GC = "Gross changes", NG = "Net Gain", NL = "Net Loss"),
             color = c(GC = "gray70", NG = "#006400", NL = "#EE2C2C"))


}
