% Generated by roxygen2 (4.0.2): do not edit by hand
\name{getSolutions}
\alias{getSolutions}
\title{Returns designs for a given "simon"-object (see \code{\link{setupSimon}})}
\usage{
getSolutions(simon = setupSimon(), useCurtailment = FALSE,
  curtail_All = FALSE, cut = 0, replications = 10000, upperBorder = 0)
}
\arguments{
\item{simon}{a "simon"-object which will be used to calculate designs.}

\item{useCurtailment}{boolean value determining whether (non-)stochastic curtailment is used.}

\item{curtail_All}{boolean value; if true the effect of (non-)stochastic curtailment will be calculated for different cut points in 0.05 steps starting with the value of the parameter "cut".}

\item{cut}{sets the "cut point" used to calculate the effect of (non-)stochastic curtailment. A study is stopped if the conditional power falls below the value of "cut".}

\item{replications}{number of simulations to estimate the effect of (non-)stochastic curtailment.}

\item{upperBorder}{maximal possible value for n. If set to sero (default) the programm will aproximate a upper border automaticly.}
}
\description{
getSolutions uses a "simon"-object to calculate two-stage designs as they were described by Simon.
}
\examples{
\dontrun{
# Example 1: Using the default values
designs <- getSolutions()
designs <- designs$Solutions
designs

# Example 2: Setting up a "simon"-object, then calculate designs
simon <- setupSimon(alpha = 0.1, beta = 0.2, p0 = 0.3, p1 = 0.5)
designs <- getSolutions(simon)$Solutions
designs

# Esample 3: Calculating designs and simulating the influence of
# stochastic curtailment for each design.
simon <- setupSimon(alpha = 0.1, beta = 0.2, p0 = 0.3, p1 = 0.5)
designs <- getSolutions(simon, useCurtailment = TRUE, curtail_All = TRUE, cut = 0.3)
#List containing the found designs, the influence of stochastic curtailment
# and the regarding stopping rules.
designs
}
}
\references{
Simon, R. (1989): Optimal two-stage designs for phase II clinical trials. Controlled Clinical Trials 10,1-10.

Kunz C.U., Kieser M (2012): Curtailment in single-arm two-stage phase II oncology trials. Biometrical Journal 54, 445-456
}
\seealso{
\code{\link{setupSimon}}
}

