% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omics-class.R
\name{omics}
\alias{omics}
\title{Abstract omics class}
\value{
A list of components:
\itemize{
\item \code{div} A \link[base]{data.frame} from \link{diversity}.
\item \code{stats} A pairwise statistics from \link[rstatix]{pairwise_wilcox_test}.
\item \code{plot} A \link[ggplot2]{ggplot} object.
}

A list of components:
\itemize{
\item \code{data} A \link[data.table]{data.table} of feature compositions.
\item \code{palette} A \link[stats]{setNames} palette from \link{colormap}.
}

A list of components:
\itemize{
\item \code{distmat} A distance dissimilarity in \link[base]{matrix} format.
\item \code{stats} A statistical test as a \link[base]{data.frame}.
\item \code{pcs} principal components as a \link[base]{data.frame}.
\item \code{scree_plot} A \link[ggplot2]{ggplot} object.
\item \code{anova_plot} A \link[ggplot2]{ggplot} object.
\item \code{scores_plot} A \link[ggplot2]{ggplot} object.
}

\itemize{
\item \code{dfe} A long \link[data.table]{data.table} table.
\item \code{volcano_plot} A \link[ggplot2]{ggplot} object.
}
}
\description{
This is the abstract class 'omics', contains a variety of methods that are inherited and applied in the omics classes:
\link{metagenomics}, proteomics and metabolomics.
}
\details{
Every class is created with the \link[R6]{R6Class} method. Methods are either public or private, and only the public components are inherited by other omic classes.
The omics class by default uses a \link[Matrix]{sparseMatrix} and \link[data.table]{data.table} data structures for quick and efficient data manipulation and returns the object by reference, same as the R6 class.
The method by reference is very efficient when dealing with big data.
}
\examples{

## ------------------------------------------------
## Method `omics$removeZeros`
## ------------------------------------------------

obj_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
obj <- readRDS(obj_path)

obj$removeZeros()


## ------------------------------------------------
## Method `omics$removeNAs`
## ------------------------------------------------

obj_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
obj <- readRDS(obj_path)

obj$removeNAs(column = "treatment")


## ------------------------------------------------
## Method `omics$feature_subset`
## ------------------------------------------------

obj_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
obj <- readRDS(obj_path)

obj$feature_subset(Genus == "Streptococcus")


## ------------------------------------------------
## Method `omics$sample_subset`
## ------------------------------------------------

obj_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
obj <- readRDS(obj_path)

obj$sample_subset(treatment == "tumor")


## ------------------------------------------------
## Method `omics$feature_merge`
## ------------------------------------------------

obj_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
obj <- readRDS(obj_path)

obj$feature_merge(feature_rank = c("Kingdom", "Phylum"))
obj$feature_merge(feature_rank = "Genus", feature_filter = c("uncultured", "metagenome"))


## ------------------------------------------------
## Method `omics$transform`
## ------------------------------------------------

obj_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
obj <- readRDS(obj_path)

obj$transform(log2)


## ------------------------------------------------
## Method `omics$normalize`
## ------------------------------------------------

obj_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
obj <- readRDS(obj_path)

obj$normalize()


## ------------------------------------------------
## Method `omics$rankstat`
## ------------------------------------------------

library(ggplot2)

obj_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
obj <- readRDS(obj_path)

plt <- obj$rankstat(feature_ranks = c("Kingdom", "Phylum", "Family", "Genus", "Species"))
plt

## ------------------------------------------------
## Method `omics$alpha_diversity`
## ------------------------------------------------

library(ggplot2)

obj_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
obj <- readRDS(obj_path)

plt <- obj$alpha_diversity(col_name = "treatment",
                           metric = "shannon")


## ------------------------------------------------
## Method `omics$composition`
## ------------------------------------------------

library(ggplot2)

obj_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
obj <- readRDS(obj_path)

result <- obj$composition(feature_rank = "Genus",
                          feature_filter = c("uncultured"),
                          feature_top = 10)

plt <- composition_plot(data = result$data,
                        palette = result$palette,
                        feature_rank = "Genus")


## ------------------------------------------------
## Method `omics$ordination`
## ------------------------------------------------

library(ggplot2)

obj_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
obj <- readRDS(obj_path)

pcoa_plots <- obj$ordination(metric = "bray",
                             method = "pcoa",
                             group_by = "treatment",
                             weighted = TRUE,
                             normalize = TRUE)
pcoa_plots


## ------------------------------------------------
## Method `omics$DFE`
## ------------------------------------------------

library(ggplot2)

obj_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
obj <- readRDS(obj_path)

unpaired <- obj$DFE(feature_rank = "Genus",
                    paired = FALSE,
                    condition.group = "treatment",
                    condition_A = c("healthy"),
                    condition_B = c("tumor"))

}
\seealso{
\link{diversity_plot}

\link{composition_plot}

\link{ordination_plot}, \link{plot_pairwise_stats}, \link{pairwise_anosim}, \link{pairwise_adonis}

\link{volcano_plot}, \link{foldchange}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{countData}}{A path to an existing file, data.table or data.frame.}

\item{\code{featureData}}{A path to an existing file, data.table or data.frame.}

\item{\code{metaData}}{A path to an existing file, data.table or data.frame.}

\item{\code{.valid_schema}}{Boolean value for schema validation via JSON}

\item{\code{.feature_id}}{A character, default name for the feature identifiers.}

\item{\code{.sample_id}}{A character, default name for the sample identifiers.}

\item{\code{.samplepair_id}}{A character, default name for the sample pair identifiers.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-omics-new}{\code{omics$new()}}
\item \href{#method-omics-validate}{\code{omics$validate()}}
\item \href{#method-omics-removeZeros}{\code{omics$removeZeros()}}
\item \href{#method-omics-removeNAs}{\code{omics$removeNAs()}}
\item \href{#method-omics-feature_subset}{\code{omics$feature_subset()}}
\item \href{#method-omics-sample_subset}{\code{omics$sample_subset()}}
\item \href{#method-omics-samplepair_subset}{\code{omics$samplepair_subset()}}
\item \href{#method-omics-feature_merge}{\code{omics$feature_merge()}}
\item \href{#method-omics-transform}{\code{omics$transform()}}
\item \href{#method-omics-normalize}{\code{omics$normalize()}}
\item \href{#method-omics-rankstat}{\code{omics$rankstat()}}
\item \href{#method-omics-alpha_diversity}{\code{omics$alpha_diversity()}}
\item \href{#method-omics-composition}{\code{omics$composition()}}
\item \href{#method-omics-ordination}{\code{omics$ordination()}}
\item \href{#method-omics-DFE}{\code{omics$DFE()}}
\item \href{#method-omics-autoFlow}{\code{omics$autoFlow()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-omics-new"></a>}}
\if{latex}{\out{\hypertarget{method-omics-new}{}}}
\subsection{Method \code{new()}}{
Wrapper function that is inherited and adapted for each omics class.
The omics classes requires a metadata samplesheet, that is validated by the metadata_schema.json.
It requires a column \code{SAMPLE_ID} and optionally a \code{SAMPLEPAIR_ID} or \code{FEATURE_ID} can be supplied.
The \code{SAMPLE_ID} will be used to link the metaData to the countData, and will act as the key during subsetting of other columns.
To create a new object use \href{#method-new}{\code{new()}} method. Do notice that the abstract class only checks if the metadata is valid!
The \code{countData} and \code{featureData} will not be checked, these are handles by the sub-classes.
Using the omics class to load your data is not supported and still experimental.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{omics$new(countData = NULL, featureData = NULL, metaData = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{countData}}{A path to an existing file, data.table or data.frame.}

\item{\code{featureData}}{A path to an existing file, data.table or data.frame.}

\item{\code{metaData}}{A path to an existing file, data.table or data.frame.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{omics} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-omics-validate"></a>}}
\if{latex}{\out{\hypertarget{method-omics-validate}{}}}
\subsection{Method \code{validate()}}{
Validates an input metadata against the JSON schema. The metadata should look as follows and should not contain any empty spaces.
For example; \code{'sample 1'} is not allowed, whereas \code{'sample1'} is allowed!

Acceptable column headers:
\itemize{
\item SAMPLE_ID (required)
\item SAMPLEPAIR_ID (optional)
\item FEATURE_ID (optional)
\item CONTRAST_ (optional), used for \href{#method-autoFlow}{\code{autoFlow()}}.
\item VARIABLE_ (optional), not supported yet.
}

This function is used during the creation of a new object via \href{#method-new}{\code{new()}} to validate the supplied metadata
via a filepath or existing \link[data.table]{data.table} or \link[base]{data.frame}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{omics$validate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
None
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-omics-removeZeros"></a>}}
\if{latex}{\out{\hypertarget{method-omics-removeZeros}{}}}
\subsection{Method \code{removeZeros()}}{
Removes empty (zero) values by row and column from the \code{countData}.
This method is performed automatically during subsetting of the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{omics$removeZeros()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
object in place
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{obj_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
obj <- readRDS(obj_path)

obj$removeZeros()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-omics-removeNAs"></a>}}
\if{latex}{\out{\hypertarget{method-omics-removeNAs}{}}}
\subsection{Method \code{removeNAs()}}{
Remove NAs from \code{metaData} and updates the \code{countData}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{omics$removeNAs(column)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{column}}{The column from where NAs should be removed, this can be either a wholenumbers or characters. Vectors are also supported.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
object in place
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{obj_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
obj <- readRDS(obj_path)

obj$removeNAs(column = "treatment")

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-omics-feature_subset"></a>}}
\if{latex}{\out{\hypertarget{method-omics-feature_subset}{}}}
\subsection{Method \code{feature_subset()}}{
Feature subset (based on \code{featureData}), automatically applies \href{#method-removeZeros}{\code{removeZeros()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{omics$feature_subset(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Expressions that return a logical value, and are defined in terms of the variables in \code{featureData}.
Only rows for which all conditions evaluate to TRUE are kept.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
object in place
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{obj_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
obj <- readRDS(obj_path)

obj$feature_subset(Genus == "Streptococcus")

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-omics-sample_subset"></a>}}
\if{latex}{\out{\hypertarget{method-omics-sample_subset}{}}}
\subsection{Method \code{sample_subset()}}{
Sample subset (based on \code{metaData}), automatically applies \href{#method-removeZeros}{\code{removeZeros()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{omics$sample_subset(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Expressions that return a logical value, and are defined in terms of the variables in \code{metaData}.
Only rows for which all conditions evaluate to TRUE are kept.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
object in place
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{obj_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
obj <- readRDS(obj_path)

obj$sample_subset(treatment == "tumor")

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-omics-samplepair_subset"></a>}}
\if{latex}{\out{\hypertarget{method-omics-samplepair_subset}{}}}
\subsection{Method \code{samplepair_subset()}}{
Samplepair subset (based on \code{metaData}), automatically applies \href{#method-removeZeros}{\code{removeZeros()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{omics$samplepair_subset(num_unique_pairs = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{num_unique_pairs}}{An integer value to define the number of pairs to subset. The default is NULL,
meaning the maximum number of unique pairs will be used to subset the data.
Let's say you have three samples for each pair, then the \code{num_unique_pairs} will be set to 3.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
object in place
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-omics-feature_merge"></a>}}
\if{latex}{\out{\hypertarget{method-omics-feature_merge}{}}}
\subsection{Method \code{feature_merge()}}{
Agglomerates features by column, automatically applies \href{#method-removeZeros}{\code{removeZeros()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{omics$feature_merge(feature_rank, feature_filter = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature_rank}}{A character value or vector of columns to aggregate from the \code{featureData}.}

\item{\code{feature_filter}}{A character value or vector of characters to remove features via regex pattern.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
object in place
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{obj_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
obj <- readRDS(obj_path)

obj$feature_merge(feature_rank = c("Kingdom", "Phylum"))
obj$feature_merge(feature_rank = "Genus", feature_filter = c("uncultured", "metagenome"))

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-omics-transform"></a>}}
\if{latex}{\out{\hypertarget{method-omics-transform}{}}}
\subsection{Method \code{transform()}}{
Performs transformation on the positive values from the \code{countData}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{omics$transform(FUN)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{FUN}}{A function such as \code{log2}, \code{log}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
object in place
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{obj_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
obj <- readRDS(obj_path)

obj$transform(log2)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-omics-normalize"></a>}}
\if{latex}{\out{\hypertarget{method-omics-normalize}{}}}
\subsection{Method \code{normalize()}}{
Relative abundance computation by column sums on the \code{countData}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{omics$normalize()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
object in place
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{obj_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
obj <- readRDS(obj_path)

obj$normalize()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-omics-rankstat"></a>}}
\if{latex}{\out{\hypertarget{method-omics-rankstat}{}}}
\subsection{Method \code{rankstat()}}{
Rank statistics based on \code{featureData}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{omics$rankstat(feature_ranks)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature_ranks}}{A vector of characters or integers that match the \code{featureData}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Counts the number of features identified for each column, for example in case of 16S metagenomics it would be the number of OTUs or ASVs on different taxonomy levels.
}

\subsection{Returns}{
A \link[ggplot2]{ggplot} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(ggplot2)

obj_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
obj <- readRDS(obj_path)

plt <- obj$rankstat(feature_ranks = c("Kingdom", "Phylum", "Family", "Genus", "Species"))
plt
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-omics-alpha_diversity"></a>}}
\if{latex}{\out{\hypertarget{method-omics-alpha_diversity}{}}}
\subsection{Method \code{alpha_diversity()}}{
Alpha diversity based on \link{diversity}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{omics$alpha_diversity(
  col_name,
  metric = c("shannon", "invsimpson", "simpson"),
  Brewer.palID = "Set2",
  evenness = FALSE,
  paired = FALSE,
  p.adjust.method = "fdr"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{col_name}}{A character variable from the \code{metaData}.}

\item{\code{metric}}{An alpha diversity metric as input to \link{diversity}.}

\item{\code{Brewer.palID}}{A character name for the palette set to be applied, see \link[RColorBrewer]{brewer.pal} or \link{colormap}.}

\item{\code{evenness}}{A boolean wether to divide diversity by number of species, see \link[vegan]{specnumber}.}

\item{\code{paired}}{A boolean value to perform paired analysis in \link[stats]{wilcox.test} and samplepair subsetting via \href{#method-samplepair_subset}{\code{samplepair_subset()}}}

\item{\code{p.adjust.method}}{A character variable to specify the p.adjust.method to be used, default is 'fdr'.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(ggplot2)

obj_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
obj <- readRDS(obj_path)

plt <- obj$alpha_diversity(col_name = "treatment",
                           metric = "shannon")

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-omics-composition"></a>}}
\if{latex}{\out{\hypertarget{method-omics-composition}{}}}
\subsection{Method \code{composition()}}{
Creates a table most abundant compositional features. Also assigns a color blind friendly palette for visualizations.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{omics$composition(
  feature_rank,
  feature_filter = NULL,
  col_name = NULL,
  normalize = TRUE,
  feature_top = c(10, 15),
  Brewer.palID = "RdYlBu"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature_rank}}{A character variable in \code{featureData} to aggregate via \href{#method-feature_merge}{\code{feature_merge()}}.}

\item{\code{feature_filter}}{A character or vector of characters to removes features by regex pattern.}

\item{\code{col_name}}{Optional, a character or vector of characters to add to the final compositional data output.}

\item{\code{normalize}}{A boolean value, whether to \href{#method-normalize}{\code{normalize()}} by total sample sums (Default: TRUE).}

\item{\code{feature_top}}{A wholenumber of the top features to visualize, the max is 15, due to a limit of palettes.}

\item{\code{Brewer.palID}}{A character name for the palette set to be applied, see \link[RColorBrewer]{brewer.pal} or \link{colormap}.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(ggplot2)

obj_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
obj <- readRDS(obj_path)

result <- obj$composition(feature_rank = "Genus",
                          feature_filter = c("uncultured"),
                          feature_top = 10)

plt <- composition_plot(data = result$data,
                        palette = result$palette,
                        feature_rank = "Genus")

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-omics-ordination"></a>}}
\if{latex}{\out{\hypertarget{method-omics-ordination}{}}}
\subsection{Method \code{ordination()}}{
Ordination of \code{countData} with statistical testing.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{omics$ordination(
  metric = c("bray", "jaccard", "unifrac"),
  method = c("pcoa", "nmds"),
  group_by,
  distmat = NULL,
  weighted = TRUE,
  normalize = TRUE,
  cpus = 1,
  perm = 999
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metric}}{A dissimilarity or similarity metric to be applied on the \code{countData},
thus far supports 'bray', 'jaccard' and 'unifrac' when a tree is provided via \code{treeData}, see \link[rbiom]{bdiv_distmat}.}

\item{\code{method}}{Ordination method, supports "pcoa" and "nmds", see \link[vegan]{wcmdscale}.}

\item{\code{group_by}}{A character variable in \code{metaData} to be used for the \link{pairwise_adonis} or \link{pairwise_anosim} statistical test.}

\item{\code{distmat}}{A custom distance matrix in either \link[stats]{dist} or \link[Matrix]{Matrix} format.}

\item{\code{weighted}}{A boolean value, whether to compute weighted or unweighted dissimilarities (Default: TRUE).}

\item{\code{normalize}}{A boolean value, whether to \href{#method-normalize}{\code{normalize()}} by total sample sums (Default: TRUE).}

\item{\code{cpus}}{A wholenumber, indicating the number of processes to spawn (Default: 1) in \link[rbiom]{bdiv_distmat}.}

\item{\code{perm}}{A wholenumber, number of permutations to compare against the null hypothesis of \link[vegan]{adonis2} and \link[vegan]{anosim} (default: \code{perm=999}).}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(ggplot2)

obj_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
obj <- readRDS(obj_path)

pcoa_plots <- obj$ordination(metric = "bray",
                             method = "pcoa",
                             group_by = "treatment",
                             weighted = TRUE,
                             normalize = TRUE)
pcoa_plots

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-omics-DFE"></a>}}
\if{latex}{\out{\hypertarget{method-omics-DFE}{}}}
\subsection{Method \code{DFE()}}{
Differential feature expression (DFE) using the \link{foldchange} for both paired and non-paired test.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{omics$DFE(
  feature_rank,
  feature_filter = NULL,
  paired = FALSE,
  normalize = TRUE,
  condition.group,
  condition_A,
  condition_B,
  pvalue.threshold = 0.05,
  foldchange.threshold = 0.06,
  abundance.threshold = 0
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature_rank}}{A character or vector of characters in the \code{featureData} to aggregate via \href{#method-feature_merge}{\code{feature_merge()}}.}

\item{\code{feature_filter}}{A character or vector of characters to remove features via regex pattern (Default: NULL).}

\item{\code{paired}}{A boolean value, the paired is only applicable when a \code{SAMPLEPAIR_ID} column exists within the \code{metaData}. See \link[stats]{wilcox.test} and \href{#method-samplepair_subset}{\code{samplepair_subset()}}.}

\item{\code{normalize}}{A boolean value, whether to \href{#method-normalize}{\code{normalize()}} by total sample sums (Default: TRUE).}

\item{\code{condition.group}}{A character variable of an existing column name in \code{metaData}, wherein the conditions A and B are located.}

\item{\code{condition_A}}{A character value or vector of characters.}

\item{\code{condition_B}}{A character value or vector of characters.}

\item{\code{pvalue.threshold}}{A numeric value used as a p-value threshold to label and color significant features (Default: 0.05).}

\item{\code{foldchange.threshold}}{A numeric value used as a fold-change threshold to label and color significantly expressed features (Default: 0.06).}

\item{\code{abundance.threshold}}{A numeric value used as an abundance threshold to size the scatter dots based on their mean relative abundance (default: 0.01).}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{library(ggplot2)

obj_path <- system.file("extdata", "mock_taxa.rds", package = "OmicFlow", mustWork = TRUE)
obj <- readRDS(obj_path)

unpaired <- obj$DFE(feature_rank = "Genus",
                    paired = FALSE,
                    condition.group = "treatment",
                    condition_A = c("healthy"),
                    condition_B = c("tumor"))

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-omics-autoFlow"></a>}}
\if{latex}{\out{\hypertarget{method-omics-autoFlow}{}}}
\subsection{Method \code{autoFlow()}}{
Automated Omics Analysis based on the \code{metaData}, see \href{#method-validate}{\code{validate()}}.
For now only works with headers that start with prefix \code{CONTRAST_}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{omics$autoFlow(
  feature_ranks = c("Kingdom", "Phylum", "Class", "Order", "Family", "Genus", "Species"),
  feature_contrast = c("Phylum", "Family", "Genus"),
  feature_filter = c("uncultured"),
  distance_metrics = c("unifrac"),
  beta_div_table = NULL,
  alpha_div_table = NULL,
  normalize = TRUE,
  weighted = TRUE,
  pvalue.threshold = 0.05,
  perm = 999,
  cpus = 1,
  filename = paste0(getwd(), "report.html")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{feature_ranks}}{A character vector as input to \href{#method-rankstat}{\code{rankstat()}}.}

\item{\code{feature_contrast}}{A character vector of feature columns in the \code{featureData} to aggregate via \href{#method-feature_merge}{\code{feature_merge()}}.}

\item{\code{feature_filter}}{A character vector to filter unwanted features, default: \code{c("uncultured")}}

\item{\code{distance_metrics}}{A character vector specifying what (dis)similarity metrics to use, default \code{c("unifrac")}}

\item{\code{beta_div_table}}{A path to pre-computed distance matrix, expects tsv/csv/txt file.}

\item{\code{alpha_div_table}}{A path to pre-computed alpha diversity with rarefraction depth, expects tsv/csv/txt from qiime2, see \link{read_rarefraction_qiime}.}

\item{\code{normalize}}{A boolean value, whether to \href{#method-normalize}{\code{normalize()}} by total sample sums (Default: TRUE).}

\item{\code{weighted}}{A boolean value, whether to compute weighted or unweighted dissimilarities (Default: TRUE).}

\item{\code{pvalue.threshold}}{A numeric value, the p-value is used to include/exclude composition and foldchanges plots coming from alpha- and beta diversity analysis (Default: 0.05).}

\item{\code{perm}}{A wholenumber, number of permutations to compare against the null hypothesis of \link[vegan]{adonis2} or \link[vegan]{anosim} (default: \code{perm=999}).}

\item{\code{cpus}}{Number of cores to use, only used in \href{#method-ordination}{\code{ordination()}} when beta_div_table is not supplied.}

\item{\code{filename}}{A character to name the HTML report, it can also be a filepath (e.g. \code{"/path/to/report.html"}). Default: "report.html" in your current work directory.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A report in HTML format
}
}
}
