/*
 * Decompiled with CFR 0.152.
 */
package org.andwellness.xml.datagenerator.custom;

import java.io.StringReader;
import java.util.List;
import org.andwellness.config.grammar.parser.ConditionParser;
import org.andwellness.config.grammar.parser.ParseException;
import org.andwellness.config.grammar.syntaxtree.start;
import org.andwellness.xml.datagenerator.custom.ConditionDepthFirst;
import org.andwellness.xml.datagenerator.model.DataPoint;
import org.apache.log4j.Logger;

public class DataPointConditionEvaluator {
    private static boolean conditionParserInitialized = false;
    private static Logger _logger = Logger.getLogger(DataPointConditionEvaluator.class);

    public static boolean evaluateCondition(String condition2, List<DataPoint> previousResponses) {
        if (!"".equals(condition2)) {
            start s = null;
            try {
                if (!conditionParserInitialized) {
                    new ConditionParser(new StringReader(condition2));
                    conditionParserInitialized = true;
                } else {
                    ConditionParser.ReInit(new StringReader(condition2));
                }
                s = ConditionParser.start();
                ConditionDepthFirst visitor = new ConditionDepthFirst(previousResponses);
                Boolean conditionValue = (Boolean)visitor.visit(s, null);
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Condition [" + condition2 + "] evaluated as " + conditionValue.toString());
                }
                return conditionValue;
            }
            catch (ParseException pe) {
                throw new IllegalArgumentException("Condition failed to parse, should have been checked in the XML validator: " + condition2);
            }
        }
        return true;
    }
}

