% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.R
\name{print.anova.opsr}
\alias{print.anova.opsr}
\title{Print Method for ANOVA OPSR Objects}
\usage{
\method{print}{anova.opsr}(
  x,
  digits = max(getOption("digits") - 2L, 3L),
  signif.stars = getOption("show.signif.stars"),
  print.formula = TRUE,
  ...
)
}
\arguments{
\item{x}{an object of class \code{"anova.opsr"}.}

\item{digits}{minimal number of \emph{significant} digits, see \code{\link{print.default}}.}

\item{signif.stars}{if \code{TRUE}, P-values are additionally encoded visually
as 'significance stars' in order to help scanning of long coefficient tables.
It defaults to the \code{show.signif.stars} slot of \code{\link{options}}.}

\item{print.formula}{if \code{TRUE}, the formulas of the models are printed.}

\item{...}{further arguments passed to \code{\link[stats:printCoefmat]{stats::printCoefmat}}.}
}
\value{
Prints tables in a 'pretty' form and returns \code{x} invisibly.
}
\description{
Print Method for ANOVA OPSR Objects
}
\seealso{
\code{\link[stats:printCoefmat]{stats::printCoefmat}}, \code{\link{anova.opsr}}
}
