% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimGaussian.r
\name{opiPresent_for_SimGaussian}
\alias{opiPresent_for_SimGaussian}
\title{opiPresent_for_SimGaussian}
\arguments{
\item{stim}{A list that contains at least:
\itemize{
\item \code{level} which is the stim value in cd/\eqn{\mbox{m}^2}{m^2}.
}}

\item{fpr}{false positive rate for the FoS curve (range 0..1).}

\item{fnr}{false negative rate for the FoS curve (range 0..1).}

\item{tt}{mean of the assumed FoS curve in dB.}

\item{...}{Any other parameters you like, they are ignored.}
}
\value{
A list with elements:
\itemize{
\item \code{err} \code{NULL} if no error, a string message otherwise.
\item \code{seen} \code{TRUE} or \code{FALSE}.
\item \code{time} Always \code{NA}.
}
}
\description{
Determine the response to a stimuli by sampling from a cumulative Gaussian
Frequency-of-Seeing (FoS) curve (also known as the psychometric function).

The FoS has formula
\deqn{\mbox{fpr}+(1-\mbox{fpr}-\mbox{fnr})(1-\mbox{pnorm}(x, \mbox{tt}, \mbox{sd})}
where \eqn{x}{\code{x}} is the stimulus value in dB, and \code{sd} is
set by \code{opiInitialize} and \code{tt}, \code{fpr} and \code{fnr}
are parameters.

This is for internal use only, use \code{\link[=opiPresent]{opiPresent()}}.
}
\examples{
    # Stimulus is Size III white-on-white as in the HFA
chooseOpi("SimGaussian")
res <- opiInitialize(sd = 1.6)
if (!is.null(res$err))
  stop(paste("opiInitialize() failed:", res$err))

result <- opiPresent(stim = list(level = dbTocd(20)), tt = 30, fpr = 0.15, fnr = 0.01)
print(paste("Seen:", result$seen, quote = FALSE))

res <- opiClose()
if (!is.null(res$err))
  warning(paste("opiClose() failed:", res$err))

}
