% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/first_hierarchy.R
\name{first_hierarchy}
\alias{first_hierarchy}
\title{First Hierarchy Function}
\usage{
first_hierarchy(data, numK, limitsSeparation, maxDist)
}
\arguments{
\item{data}{A data frame with four columns:\cr
Initial Latitude | Initial Longitude | Final Latitude | Final Longitude}

\item{numK}{Initial number of clusters in the first call of k-means in the global hierarchy.}

\item{limitsSeparation}{Within cluster distance threshold to determine if a global cluster must be separated into two new clusters.}

\item{maxDist}{Meter distance threshold used to re-estimate centroids in global hierarchy.}
}
\value{
Returns an S3 class object similar to kmeans S3 Class, with eight properties.
}
\description{
First Hierarchy Function
}
\examples{
data(ODMeansTaxiData)
first_hierarchy_data = first_hierarchy(ODMeansTaxiData, 10, 300, 1000)
}
