% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Boston_housing}
\alias{Boston_housing}
\title{Boston_housing data}
\format{
An object of class \code{data.frame} with 501 rows and 14 columns.
}
\source{
\url{https://www.law.berkeley.edu/files/Hedonic.PDF}
}
\usage{
Boston_housing
}
\description{
This is a modified version of the famous Boston housing data set. The first five rows have been removed, we will use those to make predictions on new data. The data here is complete except for the first five rows.
The data first appeared in a paper by David Harrison, Jr. and Daniel L. Rubenfeld, Hedonic housing Prices and the demand for clean air. This was published in March, 1978.
Journal of Environmental Economics and Management 5(1):81-102. The descriptions below are quoted from the original paper:
\describe{
\item{crim}{Crime rate by town. Original data in 1970 FBI data}
\item{zn}{Proportion of a town's residential land zoned for lots greater than 25,000 square feet}
\item{indus}{Proportional non-retail business per town}
\item{chas}{Captures the amenities of a riverside location and thus should be positive}
\item{nox}{Nitrogen oxygen concentrations in part per hundred million}
\item{rm}{Average number of rooms in owner units}
\item{age}{Proportion of owner units built prior to 1940}
\item{dis}{Weighted distances to five employment centers in the Boston region}
\item{rad}{Index of accessibility to radial highways}
\item{tax}{Full property value tax rate ($/$10,000)}
\item{ptratio}{Pupil-teacher ratio by town school district}
\item{black}{Black proportion of population}
\item{lstat}{Proportion of population that is lower status (proportion of adults without some high school education and proportion of male workers classified as laborers)}
\item{medv}{Median value of owner occupied homes, from the 1970 United States census}
}
}
\keyword{datasets}
