% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nd_nfd.R
\name{nd.nfd}
\alias{nd.nfd}
\title{Network Flow Distance}
\usage{
nd.nfd(A, order = 0, out.dist = TRUE, vect = seq(from = 0, to = 10,
  length.out = 1000))
}
\arguments{
\item{A}{a list of length \eqn{N} containing adjacency matrices.}

\item{order}{the order of Laplacian; currently only 0 and 1 are supported.}

\item{out.dist}{a logical; \code{TRUE} for computed distance matrix as a \code{dist} object.}

\item{vect}{a vector of parameters \eqn{t} whose values will be used.}
}
\value{
a named list containing \describe{
\item{D}{an \eqn{(N\times N)} matrix or \code{dist} object containing pairwise distance measures.}
}
}
\description{
Network Flow Distance
}
\examples{
\dontrun{
set.seed(23)
Total<-20
N1<-Total/2
P1<-0.75
P2<-0.6
P12=0.04
Iteration<-2
CAP<-4

bb<-list()         ## edges to remove
bb[[1]]<-c(1,1)
bb[[2]]<-c(4,19)
bb[[3]]<-c(12,17)
bb[[4]]<-c(13,18)
bb[[5]]<-c(1,3)
bb[[6]]<-c(15,8)
bb[[7]]<-c(2,6)


A<-matrix(0,nrow=Total,ncol=Total)                       ######### define adjacent matrix
for(i in (1:(N1-1)))
{for(j in ((i+1):N1))
{A[i,j]<-rbinom(1,1,P1)
A[j,i]<-A[i,j]}
}

for(i in ((N1+1):(Total-1)))
{for(j in ((i+1):Total))
{ A[i,j]<-rbinom(1,1,P2)
A[j,i]<-A[i,j]
}
}
for(i in (1:N1))
{for(j in (N1+1):Total)
{A[i,j]<-rbinom(1,1,P12)
A[j,i]<-A[i,j]
}
}

listA = list()
for (i in 1:7){
   tgtA = A
   idm  = bb[[i]][1]
   idn  = bb[[i]][2]

   tgtA[idm,idn] = 0
   tgtA[idn,idm] = 0
   listA[[i]] = tgtA
}

# compute two diffusion-based distances and visualize
out1 = nd.gdd(listA, out.dist=FALSE)$D
out2 = testdec(listA, out.dist=FALSE)$D
par(mfrow=c(1,2))
image(pracma::flipud(out1),col=gray((0:32)/32), main="Hammond Pairwise Distance",axes=FALSE)
image(pracma::flipud(out2),col=gray((0:32)/32), main="Dianbin Pairwise Distance",axes=FALSE)
}

}
