% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_helper_net.r
\name{analyze_ptn}
\alias{analyze_ptn}
\title{analyze public transportation network characteristics}
\usage{
analyze_ptn(g)
}
\arguments{
\item{g}{\code{\link{igraph}} object, network graph representing the public transportation network, vertices represent stations, which are linked by an edge if there is a direct transfer between them}
}
\value{
\code{'data.frame':} 1 obs. of 7 variables: 
  \itemize{
     \item \code{vcount} number of nodes, 
     \item \code{ecount} number of edges, 
     \item \code{density} network graph density, 
     \item \code{av_deg} average degree, 
     \item \code{av_cent} average unit betweenness,
     \item \code{diam} diameter, and 
     \item \code{trans} transitivity.
}
}
\description{
analyze public transportation network characteristics
}
\examples{
data(ptnAth)
analyze_ptn(ptnAth)

data(ptnGoe)
analyze_ptn(ptnGoe)

}
\references{
Details to the computation and interpretation can be found in:\itemize{
 \item Kolaczyk, E. D. (2009). Statistical analysis of network data: methods and models. Springer series in statistics. Springer. <DOI: 10.1007/978-0-387-88146-1>
 \item Manitz, J. (2014): Statistical Inference for Propagation Processes on Complex Networks. Ph.D. thesis, Georg-August-University Goettingen. Verlag Dr.~Hut, ISBN 978-3-8439-1668-4. Available online: \url{https://ediss.uni-goettingen.de/handle/11858/00-1735-0000-0022-5F38-B}.
}
}
\seealso{
Other network helper: 
\code{\link{plot_ptn}()}
}
\concept{network helper}
