% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agentset-functions.R
\docType{methods}
\name{inRadius}
\alias{inRadius}
\alias{inRadius,matrix,numeric,matrix-method}
\title{Agents in radius}
\usage{
inRadius(agents, radius, agents2, world, torus = FALSE)

\S4method{inRadius}{matrix,numeric,matrix}(agents, radius, agents2, world,
  torus = FALSE)
}
\arguments{
\item{agents}{Matrix (ncol = 2) with the first column "pxcor" and the second
              column "pycor" representing the patches coordinates, or

              AgentMatrix object representing the moving agents.}

\item{radius}{Numeric. Vector of distances from \code{agents} to locate
\code{agents2}. Must be of length 1 or of length \code{agents}.}

\item{agents2}{Matrix (ncol = 2) with the first column "pxcor" and the second
              column "pycor" representing the patches coordinates, or

              AgentMatrix object representing the moving agents.}

\item{world}{WorldMatrix or worldArray object.}

\item{torus}{Logical to determine if the \code{world} is wrapped. Default is
\code{torus = FALSE}.}
}
\value{
Matrix (ncol = 3) with the first column "pxcor"
        and the second column "pycor" representing the coordinates of the
        patches among \code{agents2} within \code{radius} distances for each \code{agents}
        which are reprensented by the "id" column, if
        \code{agents2} are patches, or

        Matrix (ncol = 2) with the first column "who"
        representing the "who" numbers of the
        turtles among \code{agents2} within \code{radius} distances for each \code{agents}
        which are reprensented by the "id" column, if
        \code{agents2} are turtles.
}
\description{
Report the patches or turtles among \code{agents2} within given distances of
each of the \code{agents}. Currently, this function multiplies \code{radius} by
1.0000001 so that the response of \code{inRadius} is inclusive.
}
\details{
Distances from/to patches are calculated from/to their center.

         If \code{torus = FALSE}, \code{world} does not need to be provided.

         If \code{torus = TRUE}, the \code{radius} distances are calculared
         around the sides of the \code{world} to select \code{agents2}.
}
\examples{
w1 <- createWorld(minPxcor = 0, maxPxcor = 4, minPycor = 0, maxPycor = 4)
t1 <- createTurtles(n = 10, coords = randomXYcor(w1, n = 10))

p1 <- inRadius(agents = patch(w1, 0, 0), radius = 2, agents2 = patches(w1))
t2 <- inRadius(agents = patch(w1, 0, 0), radius = 2, agents2 = t1)
p2 <- inRadius(agents = t1, radius = 2, agents2 = patches(w1))
t3 <- inRadius(agents = turtle(t1, who = 0), radius = 2, agents2 = t1)


}
\references{
Wilensky, U. 1999. NetLogo. \url{http://ccl.northwestern.edu/netlogo/}.
            Center for Connected Learning and Computer-Based Modeling,
            Northwestern University. Evanston, IL.
}
\seealso{
\url{https://ccl.northwestern.edu/netlogo/docs/dictionary.html#in-radius}
}
\author{
Sarah Bauduin
}
