% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlap_network.R
\name{overlap_network}
\alias{overlap_network}
\title{Plots the overlap of multiple conditions as bipartite network}
\usage{
overlap_network(
  x,
  min.prob = 0,
  min.count = 5,
  significance = 0.01,
  specificity = 0.1,
  ignore.element = NULL,
  clusters = FALSE,
  plot.bubbles = TRUE
)
}
\arguments{
\item{x}{list of objects resulting from \code{\link{specificity}} or
\code{\link{netfacs}}}

\item{min.prob}{minimum conditional probability that should be shown in the
graph}

\item{min.count}{minimum number of times that a combination should occur
before being included in the graph}

\item{significance}{sets the level of significance that combinations have to
pass before added to the network}

\item{specificity}{for the 'reduced' graph, select only elements that surpass
this context specificity value}

\item{ignore.element}{string vector, can be used to exclude certain elements
when creating the plots}

\item{clusters}{boolean; if TRUE, the cluster_fast_greedy algorithm is used
to detect underlying community structure, based on the occurrence
probability network}

\item{plot.bubbles}{if TRUE, then the nodes in the network plots will be
surrounded by bubbles; if FALSE, the edges connect the names directly}
}
\value{
Function returns a \code{\link[ggraph]{ggraph}} plot where each
  condition is connected to those elements that occur significantly in this
  condition, and each element is connected to each condition under which it
  occurs significantly more than expected. Creates four graphs: context
  specificity, occurrence in that context, a combined graph, and a 'reduced'
  graph where edges are only included if they pass the 'specificity' value
  set by the user
}
\description{
The function takes multiple netfacs objects and plots how different elements
connect the conditions, based on the conditional probabilities that the
element occurs in the condition and that the condition is seen when the
element is present
}
\examples{
\donttest{
data(emotions_set)
emo.faces <- netfacs_multiple(
  data = emotions_set[[1]],
  condition = emotions_set[[2]]$emotion,
  ran.trials = 10,
  combination.size = 2
)
# calculate element specificity
spec <- specificity(emo.faces)

overlap <- overlap_network(spec,
                           min.prob = 0.01,
                           min.count = 3,
                           significance = 0.01,
                           specificity = 0.5,
                           ignore.element = "25",
                           clusters = TRUE,
                           plot.bubbles = TRUE)
}
}
