% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_conditional.R
\name{network_conditional}
\alias{network_conditional}
\title{Create a network based on conditional probabilities of dyads of elements}
\usage{
network_conditional(
  netfacs.data,
  min.prob = 0,
  min.count = 0,
  ignore.element = NULL,
  plot.bubbles = TRUE
)
}
\arguments{
\item{netfacs.data}{object resulting from \code{\link{netfacs}} or
\code{\link{conditional_probabilities}} functions.}

\item{min.prob}{minimum conditional probability that should be shown in the
graph}

\item{min.count}{minimum number of times that a combination should occur
before being included in the graph}

\item{ignore.element}{string vector, can be used to exclude certain elements
when creating the plots}

\item{plot.bubbles}{if TRUE (default), then the nodes in the network plots
will be surrounded by bubbles; if FALSE, the edges connect the names
directly}
}
\value{
Function returns named list that includes a
  \code{\link[tidygraph:tbl_graph]{tbl_graph}} network and a
  \code{\link[ggraph:ggraph]{ggraph}} plot.
}
\description{
This is a convenience function to create and visualize a network of
conditional probabilities for all dyadic element combinations of a
\code{\link{netfacs}} object. Conditional probabilities are calculated using
the \code{\link{conditional_probabilities}} function.
}
\examples{
### how do angry facial expressions differ from non-angry ones?
data(emotions_set)
angry.face <- netfacs(
  data = emotions_set[[1]],
  condition = emotions_set[[2]]$emotion,
  test.condition = "anger",
  ran.trials = 100,
  combination.size = 2
)

conditional.probs <- conditional_probabilities(angry.face)

network_conditional(
  netfacs.data = conditional.probs,
  min.prob = 0.01,
  min.count = 3,
  ignore.element = "25",
  plot.bubbles = FALSE
)
}
\seealso{
\code{\link{netfacs}}, \code{\link{conditional_probabilities}}
}
