#' AnimalSounds: Animal Sounds for Bioacustic Analysis
#' 
#' NatureSounds is a package containing a collection of example animal sounds for bioacoustic analysis. 
#' The main goal is to provide example recordings to faciliate the development of bioacoustic 
#' tools in the R environment. 
#' 
#' Most data sets are provided as extended selection tables. These are R objects that contains both the annotations (locations of signals in time and frequency) and the corresponding acoustic data as wave objects. Therefore, these are **self-contained objects** since the original sound files are no longer needed to perform acoustic analyses. These objects are created by the `selection_table()` function from \href{https://cran.r-project.org/package=warbleR}{warbleR}. Take a look at the \href{https://cran.r-project.org/package=warbleR/vignettes/Intro_to_warbleR.html}{intro to warbleR vignette} for more details. Check out the packages \href{https://cran.r-project.org/package=warbleR}{warbleR}, \href{https://cran.r-project.org/package=tuneR}{tuneR} and \href{https://cran.r-project.org/package=seewave}{seewave} for sound file manipulation and analysis in R.
#' 
#' @import knitr
#' 
#' @author Marcelo Araya-Salas
#' Maintainer: Marcelo Araya-Salas (\email{marceloa27@@gmail.com})
#'   
#' @docType package
#' @name NatureSounds
#' @details License: GPL (>= 2)  
NULL
#> NULL 
#'
