% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nasdaq_data_link.R
\name{NasdaqDataLink.dataset.get}
\alias{NasdaqDataLink.dataset.get}
\title{Retrieves Data from the Nasdaq Data Link Dataset endpoint}
\usage{
NasdaqDataLink.dataset.get(code, params)
}
\arguments{
\item{code}{Dataset code on Nasdaq Data Link specified as a string.}

\item{params}{A list of parameters to be passed to the Nasdaq Data Link API. Please see \url{https://docs.data.nasdaq.com/docs/in-depth-usage#get-time-series-metadata} for a full list of parameters.}
}
\value{
Returns a data.frame of the requested data
}
\description{
Retrieves Data from the Nasdaq Data Link Dataset endpoint
}
\details{
Set your \code{api_key} with \code{NasdaqDataLink.api_key} function. For instructions on finding your api key go to \url{https://data.nasdaq.com/account/profile}
}
\examples{
\dontrun{
data_link_data = NasdaqDataLink.dataset.get("NSE/OIL", list(rows=5))
plot(data_link_data[,1])
}
}
\seealso{
\code{\link{NasdaqDataLink.api_key}}, \code{\link{NasdaqDataLink}}
}
