% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TAR.r
\name{uTAR}
\alias{uTAR}
\title{Estimation of a Univariate Two-Regime SETAR Model}
\usage{
uTAR(
  y,
  p1,
  p2,
  d = 1,
  thrV = NULL,
  thrQ = c(0, 1),
  Trim = c(0.1, 0.9),
  include.mean = TRUE,
  method = "RLS",
  k0 = 300
)
}
\arguments{
\item{y}{a vector of time series.}

\item{p1, p2}{AR-orders of regime 1 and regime 2.}

\item{d}{delay for threshold variable, default is 1.}

\item{thrV}{threshold variable. If thrV is not null, it must have the same length as that of y.}

\item{thrQ}{lower and upper quantiles to search for threshold value.}

\item{Trim}{lower and upper quantiles for possible threshold values.}

\item{include.mean}{a logical value indicating whether constant terms are included.}

\item{method}{"RLS": estimate the model by conditional least squares method implemented by recursive least squares; "NeSS": estimate the model by conditional least squares method implemented by Nested sub-sample search (NeSS) algorithm.}

\item{k0}{the maximum number of threshold values to be evaluated, when the nested sub-sample search (NeSS) method is used. If the sample size is large (> 3000), then k0 = floor(nT*0.5). The default is k0=300. But k0 = floor(nT*0.8) if nT < 300.}
}
\value{
uTAR returns a list with components:
\item{data}{the data matrix, y.}
\item{arorder}{AR orders of regimes 1 and 2.}
\item{delay}{the delay for threshold variable.}
\item{residuals}{estimated innovations.}
\item{sresi}{standardized residuals.}
\item{coef}{a 2-by-(p+1) matrices. The first row shows the estimation results in regime 1, and the second row shows these in regime 2.}
\item{sigma}{estimated innovational covariance matrices of regimes 1 and 2.}
\item{nobs}{numbers of observations in regimes 1 and 2.}
\item{model1,model2}{estimated models of regimes 1 and 2.}
\item{thr}{threshold value.}
\item{D}{a set of threshold values.}
\item{RSS}{RSS}
\item{AIC}{AIC value}
\item{cnst}{logical values indicating whether the constant terms are included in regimes 1 and 2.}
}
\description{
Estimation of a univariate two-regime SETAR model, including threshold value, performing recursive least squares method or nested sub-sample search algorithm.
The procedure of Li and Tong (2016) is used to search for the threshold.
}
\examples{
phi=t(matrix(c(-0.3, 0.5,0.6,-0.3),2,2))
y=uTAR.sim(nob=2000, arorder=c(2,2), phi=phi, d=2, thr=0.2, cnst=c(1,-1),sigma=c(1, 1))$series
est=uTAR(y=y,p1=2,p2=2,d=2,thrQ=c(0,1),Trim=c(0.1,0.9),include.mean=TRUE,method="NeSS",k0=50)
}
\references{
Li, D., and Tong. H. (2016) Nested sub-sample search algorithm for estimation of threshold models. \emph{Statisitca Sinica}, 1543-1554.
}
