% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SMC.r
\name{simPassiveSonar}
\alias{simPassiveSonar}
\title{Simulate A Sample Trajectory}
\usage{
simPassiveSonar(nn = 200, q, r, start, seed)
}
\arguments{
\item{nn}{sample size.}

\item{q}{contains the information about the covariance of the noise.}

\item{r}{contains the information about \code{V}, where \code{V*t(V)} is the covariance matrix of the observation noise.}

\item{start}{the initial value.}

\item{seed}{the seed of random number generator.}
}
\value{
The function returns a list with components:
\item{xx}{the state data.}
\item{yy}{the observed data.}
\item{H}{the state coefficient matrix.}
\item{W}{ \code{W*t(W)} is the state innovation covariance matrix.}
\item{V}{\code{V*t(V)} is the observation noise covariance matrix.}
}
\description{
The function generates a sample trajectory of the target and the corresponding observations with sensor locations at (0,0)
and (20,0).
}
\examples{
s2 <- 20 #second sonar location at (s2,0)
q <- c(0.03,0.03)
r <- c(0.02,0.02)
nobs <- 200
start <- c(10,10,0.01,0.01)
H <- c(1,0,1,0,0,1,0,1,0,0,1,0,0,0,0,1)
H <- matrix(H,ncol=4,nrow=4,byrow=TRUE)
W <- c(0.5*q[1], 0,0, 0.5*q[2],q[1],0,0,q[2])
W <- matrix(W,ncol=2,nrow=4,byrow=TRUE)
V <- diag(r)
mu0 <- start
SS0 <- diag(c(1,1,1,1))*0.01
simu_out <- simPassiveSonar(nobs,q,r,start,seed=20)
yy<- simu_out$yy
tt<- 100:200
plot(simu_out$xx[1,tt],simu_out$xx[2,tt],xlab='x',ylab='y')
}
