% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{mTAR.est}
\alias{mTAR.est}
\title{Estimation of Multivariate TAR Models}
\usage{
mTAR.est(
  y,
  arorder = c(1, 1),
  thr = c(0),
  delay = c(1, 1),
  thrV = NULL,
  include.mean = c(TRUE, TRUE),
  output = TRUE
)
}
\arguments{
\item{y}{vector time series.}

\item{arorder}{AR order of each regime. The number of regime is length of arorder.}

\item{thr}{threshold value(s). There are k-1 threshold for a k-regime model.}

\item{delay}{two elements (i,d) with "i" being the component and "d" the delay for threshold variable.}

\item{thrV}{external threshold variable if any. If thrV is not null, it must have the same number of observations as y-series.}

\item{include.mean}{logical values indicating whether constant terms are included. Default is TRUE for all.}

\item{output}{a logical value indicating four output. Default is TRUE.}
}
\value{
mTAR.est returns a list with the following components:
\item{data}{the data matrix, \code{y}.}
\item{k}{the dimension of \code{y}.}
\item{arorder}{AR orders of regimes 1 and 2.}
\item{beta}{a (\code{p*k+1})-by-(\code{2k}) matrices. The first \code{k} columns show the estimation results in regime 1, and the second \code{k} columns show these in regime 2.}
\item{sigma}{estimated innovational covariance matrices of regimes 1 and 2.}
\item{thr}{threshold value.}
\item{residuals}{estimated innovations.}
\item{sresi}{standardized residuals.}
\item{nobs}{numbers of observations in different regimes.}
\item{cnst}{logical values indicating whether the constant terms are included in different regimes.}
\item{AIC}{AIC value.}
\item{delay}{two elements (\code{i,d}) with "\code{i}" being the component and "\code{d}" the delay for threshold variable.}
\item{thrV}{values of threshold variable.}
}
\description{
Estimation of multivariate TAR models with given thresholds. It can handle multiple regimes.
}
\examples{
phi1=matrix(c(0.5,0.7,0.3,0.2),2,2)
phi2=matrix(c(0.4,0.6,0.5,-0.5),2,2)
sigma1=matrix(c(1,0,0,1),2,2)
sigma2=matrix(c(1,0,0,1),2,2)
c1=c(0,0)
c2=c(0,0)
delay=c(1,1)
y=mTAR.sim(100,0,phi1,phi2,sigma1,sigma2,c1,c2,delay,ini=500)
est=mTAR.est(y$series,c(1,1),0,delay)
}
