% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{backTAR}
\alias{backTAR}
\title{Backtest for Univariate TAR Models}
\usage{
backTAR(model, orig, h = 1, iter = 3000)
}
\arguments{
\item{model}{SETAR model.}

\item{orig}{forecast origin.}

\item{h}{forecast horizon.}

\item{iter}{number of iterations.}
}
\value{
\code{backTAR} returns a list of components:
\item{model}{SETAR model.}
\item{error}{prediction errors.}
\item{State}{predicted states.}
}
\description{
Perform back-test of a univariate SETAR model.
}
\examples{
arorder=rep(1,2)
ar.coef=matrix(c(0.7,-0.8),2,1)
y=uTAR.sim(100,arorder,ar.coef,1,0)
est=uTAR.est(y$series,arorder,0,1)
backTAR(est,50,1,3000)
}
