% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOVA.R
\name{NNS.ANOVA}
\alias{NNS.ANOVA}
\title{NNS ANOVA: Nonparametric Analysis of Variance}
\usage{
NNS.ANOVA(
  control,
  treatment,
  means.only = FALSE,
  medians = FALSE,
  confidence.interval = 0.95,
  tails = "Both",
  pairwise = FALSE,
  plot = TRUE,
  robust = FALSE
)
}
\arguments{
\item{control}{Numeric vector of control group observations}

\item{treatment}{Numeric vector of treatment group observations}

\item{means.only}{Logical; \code{FALSE} (default) uses full distribution analysis. Set \code{TRUE} for mean-only comparison}

\item{medians}{Logical; \code{FALSE} (default) uses means. Set \code{TRUE} for median-based analysis}

\item{confidence.interval}{Numeric [0,1]; confidence level for effect size bounds (e.g., 0.95)}

\item{tails}{Character; specifies CI tail(s): "both", "left", or "right"}

\item{pairwise}{logical; \code{FALSE} (default) Returns pairwise certainty tests when set to \code{pairwise = TRUE}.}

\item{plot}{Logical; \code{TRUE} (default) generates distribution plot}

\item{robust}{logical; \code{FALSE} (default) Generates 100 independent random permutations to test results, and returns / plots 95 percent confidence intervals along with robust central tendency of all results for pairwise analysis only.}
}
\value{
Returns a list containing:
\itemize{
  \item \code{Control_Statistic}: Mean/median of control group
  \item \code{Treatment_Statistic}: Mean/median of treatment group
  \item \code{Grand_Statistic}: Grand mean/median
  \item \code{Control_CDF}: CDF value at grand statistic (control)
  \item \code{Treatment_CDF}: CDF value at grand statistic (treatment)
  \item \code{Certainty}: Separation certainty (0-1)
  \item \code{Effect_Size_LB}: Lower bound of treatment effect (if CI requested)
  \item \code{Effect_Size_UB}: Upper bound of treatment effect (if CI requested)
  \item \code{Confidence_Level}: Confidence level used (if CI requested)
}
}
\description{
Performs a distribution-free ANOVA using partial moment statistics to evaluate differences between control and treatment groups. Returns a certainty metric (0-1) indicating separation likelihood rather than traditional p-values. Includes bootstrapped effect size bounds.
}
\examples{
 \dontrun{
### Binary analysis and effect size
set.seed(123)
x <- rnorm(100) ; y <- rnorm(100)
NNS.ANOVA(control = x, treatment = y)

### Two variable analysis with no control variable
A <- cbind(x, y)
NNS.ANOVA(A)

### Medians test
NNS.ANOVA(A, means.only = TRUE, medians = TRUE)

### Multiple variable analysis with no control variable
set.seed(123)
x <- rnorm(100) ; y <- rnorm(100) ; z <- rnorm(100)
A <- cbind(x, y, z)
NNS.ANOVA(A)

### Different length vectors used in a list
x <- rnorm(30) ; y <- rnorm(40) ; z <- rnorm(50)
A <- list(x, y, z)
NNS.ANOVA(A)
}
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments" (ISBN: 1490523995)

Viole, F. (2017) "Continuous CDFs and ANOVA with NNS"  \doi{10.2139/ssrn.3007373}
}
\author{
Fred Viole, OVVO Financial Systems
}
