% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotKM.R
\name{plotKM}
\alias{plotKM}
\title{Plot function for pooled Kaplan-Meier estimates}
\usage{
plotKM(x, ...)
}
\arguments{
\item{x}{a data.frame contains pooled estimates of survival function generated from function 'km.pool'.}

\item{...}{further arguments passed to 'plot' function}
}
\description{
A plot of survival curves is produced.
}
\examples{

# load required packages
library(NNMIS)
library(survival)

# load data set - stanford2 in package 'survival'
data("stanford2")
head(stanford2)
attach(stanford2)

# performance multiple imputation on missing covariate t5 and
# censored observations based on the imputed missing covariates
imp.dat <- NNMIS(t5, xa=age, xb=age, time=time, event=status, imputeCT=TRUE, Seed = 1234)

# check imputation results
head(imp.dat$dat.T.NNMI)

# combine inference from imputed data sets using Rubin's rules
# Kaplan-Meier estimates
kmfit <- km.pool(imp.dat, time, status)

# Kaplan-Meier plot with pooled estimates
plotKM(kmfit)

}
\seealso{
km.pool
}
