% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visual-cluster-in-bipartite.R
\name{visualClusterInBipartite}
\alias{visualClusterInBipartite}
\title{Plot the bipartite graph with color coding for different cluster in different
projections.}
\usage{
visualClusterInBipartite(
  data,
  community_left,
  community_right,
  name_left = "Left",
  name_right = "Right"
)
}
\arguments{
\item{data}{A a dataframe containing the missing values, at least 2 nominal
columns.}

\item{community_left}{An igraph community object, one projection of the
graph, will be showed on the left side.}

\item{community_right}{An igraph community object, the other projection of the
graph, will be showed on the right side.}

\item{name_left}{A string, the name of left community.}

\item{name_right}{A string, the name of right community.}
}
\value{
A Data frame containing plotting datas.
}
\description{
This function will use sankey to draw two graphs, the left and
right parts are two projections, and in each projection, a node corresponds
to a group in the clustering result.
}
\examples{
# load part of the beatAML data and get the incidence matrix
beatAML_data <- NIMAA::beatAML[1:1000,]
beatAML_incidence_matrix <- el2IncMatrix(beatAML_data)

# extract the sub-matrix
sub_matrices <- extractSubMatrix(
beatAML_incidence_matrix,
shape = c("Rectangular_element_max") # the shapes you want to extract
)

# do clustering
cls <- findCluster(
sub_matrices$Rectangular_element_max, # the sub-matrix
dim = 1
)

cls2 <- findCluster(
sub_matrices$Rectangular_element_max, # the sub-matrix
dim = 2
)

visualClusterInBipartite(
data = beatAML_data,
community_left = cls2$leading_eigen,
community_right = cls$fast_greedy,
name_left = 'patient_id',
name_right = 'inhibitor')
}
\seealso{
\code{\link[plotly]{plot_ly}}
}
