% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-input.R
\name{plotInput}
\alias{plotInput}
\title{Plot the given data with heatmap figure.}
\usage{
plotInput(
  x,
  index_nominal = c(1, 2),
  index_numeric = NULL,
  palette = "Blues",
  verbose = FALSE,
  plot_weight = FALSE,
  print_skim = TRUE
)
}
\arguments{
\item{x}{A a dataframe containing the missing values, at least 2 nominal
columns.}

\item{index_nominal}{A vector containing two numbers, which are the indexes
for the nominal columns (the first value indicating the rows objects and
the second value indicating the column object). By default is c(1,2), i.e.,
the first two columns are nomianl columns.}

\item{index_numeric}{An integer, the index for numeric values. (this is value
for selecting the column which contains our numeric values and we change it
to the matrix for missing value investigation and imputation).}

\item{palette}{A string or number. Color palette used for the heatmap. By
default is 'Blues'. (Find the option in the manual of
\code{\link[=scale_fill_distiller]{scale_fill_distiller()}}).}

\item{verbose}{A Boolean value, If \code{TRUE}, the plot will be saved as the
.png file in the working directory. By default is \code{FALSE}.}

\item{plot_weight}{A Boolean value, If \code{TRUE}, the plot will have
corresponding colors based on weights, otherwise plot the binary/logical
matrix figure. By default is \code{FALSE}.}

\item{print_skim}{A Boolean value, If \code{TRUE}, then the funtion will
print \code{\link[skimr]{skim}} information in console.}
}
\value{
A matrix, the incidence matrix got from input data.
}
\description{
This function plot the input data in heatmap format. The row and
column are two nominal variables. The color/value of heatmap could be the
weights or logical value showing valid/missing connection.
}
\details{
This function mainly convert data in the form of edge list into
matrix data and visualize it. In addition, it will also calculate some
basic matrix properties and the proportion of missing data.
}
\examples{
# load part of the beatAML data
beatAML_data <- NIMAA::beatAML[1:1000,]

beatAML_incidence_matrix <- plotInput(beatAML_data,index_numeric=3)
}
\seealso{
\code{\link{el2IncMatrix}}
}
