% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Oemparams.R
\name{Oemparams}
\alias{Oemparams}
\title{Emission Parameters}
\usage{
Oemparams(nhmmobj, plots = FALSE, outfile = NULL)
}
\arguments{
\item{nhmmobj}{an object created from the NHMM or HMM function}

\item{plots}{TRUE/FALSE- default is FALSE because the plot window can grow quite large depending on the number of parameters.
[J by K*nmix] panes if outboo=TRUE and [K*nmix by J] panes if outboo=FALSE, 
where outboo is a parameter from NHMM which determines if output was written to a file (TRUE) or to a variable (FALSE).
If outfile is used then there will be K*J .png files containing dimension 2 parameters by nmix panes of trace plots.
Exception: NHMM_MVN, plots is always FALSE.}

\item{outfile}{a directory to put the .png plot}
}
\value{
params [2 by nmix by K by J] by 6. There are six values returned: 0.025, 0.05, mean, 0.50 (median),
0.95, 0.975 quantiles from the iterations. (0.025, 0.975) are used to construct 95% probability intervals (PIs),
likewise (0.05, 0.95) can be used to construct 90% PIs. The 2 parameter is for two-parameter distributions like Gamma
but the one-parameter distributions like the Exponential will only have meaningful data in the first row. 
Exception for NHMM_MVN then
 the parameters returned is the mean covariance matrix over all iterations [J by J by K]

output:  plot window can grow quite large depending on the number of parameters.
[J by K*nmix] panes if outboo=TRUE and [K*nmix by J] panes if outboo=FALSE, 
where outboo is a parameter from NHMM which determines if output was written to a file (TRUE) or to a variable (FALSE). 
Exception: NHMM_MVN object does not plot the covariance.
}
\description{
\code{Oemparams} calculates emission parameters 0.025, 0.05, mean, 0.50 (median),
0.95, 0.975 quantiles from the iterations for each parameter. Each of the J sequences and K states
each has 2 parameters (Gamma and Normal) or 1 parameter (Poisson) per mixture component (nmix+delta)
}
\examples{
#thetas=Oemparams(my.nhmm, FALSE); 
#thetas[,,,,3]  #mean values
}
