% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCmisc.R
\name{is.vec.numeric}
\alias{is.vec.numeric}
\title{Determine robustly whether a vector contains numeric data}
\usage{
is.vec.numeric(x, logical.is.numeric = FALSE, thresh = 0.9)
}
\arguments{
\item{x}{a vector to check for numeric status}

\item{logical.is.numeric}{by default this is FALSE, which means
logical vectors will return FALSE to being numeric. If set to
TRUE, then a variable will get a return value of TRUE if it is
based on numbers or appears to be of 'logical' type.}

\item{thresh}{threshold to decide that a variable is numeric. NA values will
be ignored in the test. Then it looks at the proportion of values that are
successfully coerced to numeric without giving 'NA'. If this threshold is
0.9, then any column where at least 90% of non-NA values can be successfully
converted to numeric type, will return TRUE for this function call.}
}
\value{
returns a logical TRUE or FALSE for the numeric status of x.
}
\description{
This is an improvement on base:is.numeric because data may be encoded as
a different type (e.g, string) especially if imported from a file.
}
\examples{
numeric1 <- 1:10
numeric2 <- paste(1:10)
string <- paste("one", "two", "three", "four")
logic1 <- c(TRUE,FALSE,FALSE,TRUE,FALSE,NA)
numericish <- paste(c(NA, NA, 6:10, "5|6", "7|8", 1))
is.vec.numeric(numeric1)
is.vec.numeric(numeric2)
is.vec.numeric(string)
is.vec.numeric(logic1)
is.vec.numeric(logic1, logical.is.numeric=TRUE)
is.vec.numeric(numericish)
is.vec.numeric(numericish, thresh=0.7)
}
\author{
Nicholas Cooper
}
