% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_methods.R
\docType{methods}
\name{inputs}
\alias{inputs}
\alias{inputs,nblda-method}
\title{Accessors for the 'input' slot.}
\usage{
\S4method{inputs}{nblda}(object)
}
\arguments{
\item{object}{an \code{nblda} object.}
}
\description{
This slot stores the input data for trained model.
}
\examples{
set.seed(2128)
counts <- generateCountData(n = 20, p = 10, K = 2, param = 1, sdsignal = 0.5, DE = 0.8,
                            allZero.rm = FALSE, tag.samples = TRUE)
x <- t(counts$x + 1)
y <- counts$y
xte <- t(counts$xte + 1)
ctrl <- nbldaControl(folds = 2, repeats = 2)

fit <- trainNBLDA(x = x, y = y, type = "mle", tuneLength = 10,
                  metric = "accuracy", train.control = ctrl)

inputs(fit)

}
\seealso{
\code{\link{trainNBLDA}}
}
