% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cenCompareQQ.R
\name{cenCompareQQ}
\alias{cenCompareQQ}
\title{Censored Q-Q Plot comparison}
\usage{
cenCompareQQ(y.var, cen.var, Yname = yname, printrslt = TRUE)
}
\arguments{
\item{y.var}{The column of y (response variable) values plus detection limits}

\item{cen.var}{The column of indicators, where 1 (or \code{TRUE}) indicates a detection limit in the \code{y.var} column, and 0 (or \code{FALSE}) indicates a detected value in \code{y.var}.}

\item{Yname}{Optional – input text in quotes to be used as the variable name on all plots.  The default \code{Yname} is the name of the \code{y.var} input variable.}

\item{printrslt}{Logical \code{TRUE}/\code{FALSE} option of whether to print the best distribution in the console window, or not.  Default is \code{TRUE.}}
}
\value{
Plots three Q-Q plots based on normal, lognormal and gamma distributions and prints the best-fit distribution.
}
\description{
Produces three quantile-quantile (Q-Q) plots, also called probability plots, based on three distributions (normal, lognormal and gamma distributions).
}
\details{
Produces three Q-Q plots and reports which one has the highest Shapiro-Francia test statistic (W).  The distribution with the highest W is the best fit of the three.
}
\examples{

data(Brumbaugh)
\donttest{cenCompareQQ(Brumbaugh$Hg,Brumbaugh$HgCen)}
}
\references{
Helsel, D.R., 2011. Statistics for censored environmental data using Minitab and R, 2nd ed. John Wiley & Sons, USA, N.J.

Millard, S.P., 2013. EnvStats: An R Package for Environmental Statistics. Springer-Verlag, New York.

Shapiro, S.S., Francia, R.S., 1972. An approximate analysis of variance test for normality. Journal of the American Statistical Association 67, 215–216.
}
