/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.parameters;

import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.mahout.common.parameters.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Parametered {
    public static final Logger log = LoggerFactory.getLogger(Parametered.class);

    public Collection<Parameter<?>> getParameters();

    public void createParameters(String var1, Configuration var2);

    public void configure(Configuration var1);

    public static final class ParameteredGeneralizations {
        private ParameteredGeneralizations() {
        }

        public static void configureParameters(Parametered parametered, Configuration jobConf) {
            ParameteredGeneralizations.configureParameters(parametered.getClass().getSimpleName() + '.', parametered, jobConf);
        }

        public static void configureParameters(String prefix, Parametered parametered, Configuration jobConf) {
            parametered.createParameters(prefix, jobConf);
            ParameteredGeneralizations.configureParametersRecursively(parametered, prefix, jobConf);
        }

        private static void configureParametersRecursively(Parametered parametered, String prefix, Configuration jobConf) {
            for (Parameter<?> parameter : parametered.getParameters()) {
                if (log.isDebugEnabled()) {
                    log.debug("Configuring {}{}", (Object)prefix, (Object)parameter.name());
                }
                String name = prefix + parameter.name() + '.';
                parameter.createParameters(name, jobConf);
                parameter.configure(jobConf);
                if (parameter.getParameters().isEmpty()) continue;
                ParameteredGeneralizations.configureParametersRecursively(parameter, name, jobConf);
            }
        }

        public static String help(Parametered parametered) {
            return new Help(parametered).toString();
        }

        public static String conf(Parametered parametered) {
            return new Conf(parametered).toString();
        }

        private static final class Conf {
            private final StringBuilder sb;
            private int longestName;
            private int numChars = 100;

            private Conf(Parametered parametered) {
                this.recurseCount(parametered);
                this.sb = new StringBuilder(this.numChars);
                this.recurseWrite(parametered);
            }

            public String toString() {
                return this.sb.toString();
            }

            private void recurseCount(Parametered parametered) {
                for (Parameter<?> parameter : parametered.getParameters()) {
                    int parameterNameLength = parameter.prefix().length() + parameter.name().length();
                    if (parameterNameLength > this.longestName) {
                        this.longestName = parameterNameLength;
                    }
                    this.numChars += parameterNameLength;
                    this.numChars += 5;
                    this.numChars += parameter.description().length();
                    if (parameter.getStringValue() != null) {
                        this.numChars += parameter.getStringValue().length();
                    }
                    this.recurseCount(parameter);
                }
            }

            private void recurseWrite(Parametered parametered) {
                for (Parameter<?> parameter : parametered.getParameters()) {
                    this.sb.append("# ");
                    this.sb.append(parameter.description());
                    this.sb.append('\n');
                    this.sb.append(parameter.prefix());
                    this.sb.append(parameter.name());
                    this.sb.append(" = ");
                    if (parameter.getStringValue() != null) {
                        this.sb.append(parameter.getStringValue());
                    }
                    this.sb.append('\n');
                    this.sb.append('\n');
                    this.recurseWrite(parameter);
                }
            }
        }

        private static final class Help {
            static final int NAME_DESC_DISTANCE = 8;
            private final StringBuilder sb;
            private int longestName;
            private int numChars = 100;

            private Help(Parametered parametered) {
                this.recurseCount(parametered);
                this.numChars += (this.longestName + 8) * parametered.getParameters().size();
                this.sb = new StringBuilder(this.numChars);
                this.recurseWrite(parametered);
            }

            public String toString() {
                return this.sb.toString();
            }

            private void recurseCount(Parametered parametered) {
                for (Parameter<?> parameter : parametered.getParameters()) {
                    int parameterNameLength = parameter.name().length();
                    if (parameterNameLength > this.longestName) {
                        this.longestName = parameterNameLength;
                    }
                    this.recurseCount(parameter);
                    this.numChars += parameter.description().length();
                }
            }

            private void recurseWrite(Parametered parametered) {
                for (Parameter<?> parameter : parametered.getParameters()) {
                    this.sb.append(parameter.prefix());
                    this.sb.append(parameter.name());
                    int max = this.longestName - parameter.name().length() - parameter.prefix().length() + 8;
                    for (int i = 0; i < max; ++i) {
                        this.sb.append(' ');
                    }
                    this.sb.append(parameter.description());
                    if (parameter.defaultValue() != null) {
                        this.sb.append(" (default value '");
                        this.sb.append(parameter.defaultValue());
                        this.sb.append("')");
                    }
                    this.sb.append('\n');
                    this.recurseWrite(parameter);
                }
            }
        }
    }
}

