/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender;

import org.apache.mahout.common.RandomUtils;

public final class SimilarUser
implements Comparable<SimilarUser> {
    private final long userID;
    private final double similarity;

    public SimilarUser(long userID, double similarity) {
        this.userID = userID;
        this.similarity = similarity;
    }

    long getUserID() {
        return this.userID;
    }

    double getSimilarity() {
        return this.similarity;
    }

    public int hashCode() {
        return (int)this.userID ^ RandomUtils.hashDouble((double)this.similarity);
    }

    public boolean equals(Object o) {
        if (!(o instanceof SimilarUser)) {
            return false;
        }
        SimilarUser other = (SimilarUser)o;
        return this.userID == other.getUserID() && this.similarity == other.getSimilarity();
    }

    public String toString() {
        return "SimilarUser[user:" + this.userID + ", similarity:" + this.similarity + ']';
    }

    @Override
    public int compareTo(SimilarUser other) {
        double otherSimilarity = other.getSimilarity();
        if (this.similarity > otherSimilarity) {
            return -1;
        }
        if (this.similarity < otherSimilarity) {
            return 1;
        }
        long otherUserID = other.getUserID();
        if (this.userID < otherUserID) {
            return -1;
        }
        if (this.userID > otherUserID) {
            return 1;
        }
        return 0;
    }
}

