/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.client;

import com.lexicalscope.jewel.cli.Option;
import com.lexicalscope.jewel.cli.Unparsed;
import java.io.File;
import java.util.List;

public interface CLIArgs {
    @Option(description="Verbose logging")
    public boolean isVerbose();

    @Option(defaultValue={"localhost"}, description="Serving Layer host name")
    public String getHost();

    @Option(defaultValue={"80"}, description="Serving Layer port number")
    public int getPort();

    @Option(description="If set, use HTTPS instead of HTTP")
    public boolean isSecure();

    @Option(defaultToNull=true, description="User name to authenticate to Serving Layer")
    public String getUserName();

    @Option(defaultToNull=true, description="Password to authenticate to Serving Layer")
    public String getPassword();

    @Option(defaultToNull=true, description="Test SSL certificate keystore to accept")
    public File getKeystoreFile();

    @Option(defaultToNull=true, description="Password for keystoreFile")
    public String getKeystorePassword();

    @Option(defaultToNull=true, description="All partitions, as comma-separated host:port (e.g. foo1:8080,foo2:80,bar1:8081), or 'auto'")
    public String getAllPartitions();

    @Option(defaultToNull=true, description="May be specified several times to specify arguments to the server's rescorer implementation")
    public List<String> getRescorerParams();

    @Option(defaultToNull=true, description="Non-root URL context path under which Serving Layer is deployed")
    public String getContextPath();

    @Option(description="Use String user IDs in client API")
    public boolean isTranslateUser();

    @Option(defaultToNull=true, description="Use String item IDs in client API. File argument contains list of all known item IDs or is set to 'oneWay'")
    public String getTranslateItem();

    @Option(helpRequest=true)
    public boolean getHelp();

    @Unparsed
    public List<String> getCommands();

    @Option(defaultValue={"10"}, description="How many recommendations or items to retrieve")
    public int getHowMany();

    @Option(description="Allow items which the user is already connected to in the result of the recommend method")
    public boolean isConsiderKnownItems();

    @Option(defaultToNull=true, description="For commands that do not directly involve a user, specifies the user for which the request is made for routing")
    public String getContextUserID();
}

