/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.als;

import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.cf.taste.common.TopK;
import org.apache.mahout.cf.taste.hadoop.RecommendedItemsWritable;
import org.apache.mahout.cf.taste.hadoop.als.ALSUtils;
import org.apache.mahout.cf.taste.impl.recommender.GenericRecommendedItem;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.function.IntObjectProcedure;
import org.apache.mahout.math.map.OpenIntObjectHashMap;
import org.apache.mahout.math.set.OpenIntHashSet;

public class RecommenderJob
extends AbstractJob {
    private static final String NUM_RECOMMENDATIONS = RecommenderJob.class.getName() + ".numRecommendations";
    private static final String USER_FEATURES_PATH = RecommenderJob.class.getName() + ".userFeatures";
    private static final String ITEM_FEATURES_PATH = RecommenderJob.class.getName() + ".itemFeatures";
    private static final String MAX_RATING = RecommenderJob.class.getName() + ".maxRating";
    static final int DEFAULT_NUM_RECOMMENDATIONS = 10;
    private static final Comparator<RecommendedItem> BY_PREFERENCE_VALUE = new Comparator<RecommendedItem>(){

        @Override
        public int compare(RecommendedItem one, RecommendedItem two) {
            return Floats.compare(one.getValue(), two.getValue());
        }
    };

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new RecommenderJob(), (String[])args);
    }

    public int run(String[] args) throws Exception {
        this.addInputOption();
        this.addOption("userFeatures", null, "path to the user feature matrix", true);
        this.addOption("itemFeatures", null, "path to the item feature matrix", true);
        this.addOption("numRecommendations", null, "number of recommendations per user", String.valueOf(10));
        this.addOption("maxRating", null, "maximum rating available", true);
        this.addOutputOption();
        Map<String, List<String>> parsedArgs = this.parseArguments(args);
        if (parsedArgs == null) {
            return -1;
        }
        Job prediction = this.prepareJob(this.getInputPath(), this.getOutputPath(), SequenceFileInputFormat.class, PredictionMapper.class, IntWritable.class, RecommendedItemsWritable.class, TextOutputFormat.class);
        prediction.getConfiguration().setInt(NUM_RECOMMENDATIONS, Integer.parseInt(this.getOption("numRecommendations")));
        prediction.getConfiguration().set(USER_FEATURES_PATH, this.getOption("userFeatures"));
        prediction.getConfiguration().set(ITEM_FEATURES_PATH, this.getOption("itemFeatures"));
        prediction.getConfiguration().set(MAX_RATING, this.getOption("maxRating"));
        boolean succeeded = prediction.waitForCompletion(true);
        if (!succeeded) {
            return -1;
        }
        return 0;
    }

    static class PredictionMapper
    extends Mapper<IntWritable, VectorWritable, IntWritable, RecommendedItemsWritable> {
        private OpenIntObjectHashMap<Vector> U;
        private OpenIntObjectHashMap<Vector> M;
        private int recommendationsPerUser;
        private float maxRating;

        PredictionMapper() {
        }

        protected void setup(Mapper.Context ctx) throws IOException, InterruptedException {
            this.recommendationsPerUser = ctx.getConfiguration().getInt(NUM_RECOMMENDATIONS, 10);
            Path pathToU = new Path(ctx.getConfiguration().get(USER_FEATURES_PATH));
            Path pathToM = new Path(ctx.getConfiguration().get(ITEM_FEATURES_PATH));
            this.U = ALSUtils.readMatrixByRows(pathToU, ctx.getConfiguration());
            this.M = ALSUtils.readMatrixByRows(pathToM, ctx.getConfiguration());
            this.maxRating = Float.parseFloat(ctx.getConfiguration().get(MAX_RATING));
        }

        protected void map(IntWritable userIDWritable, VectorWritable ratingsWritable, Mapper.Context ctx) throws IOException, InterruptedException {
            Vector ratings = ratingsWritable.get();
            final int userID = userIDWritable.get();
            final OpenIntHashSet alreadyRatedItems = new OpenIntHashSet(ratings.getNumNondefaultElements());
            final TopK topKItems = new TopK(this.recommendationsPerUser, BY_PREFERENCE_VALUE);
            Iterator ratingsIterator = ratings.iterateNonZero();
            while (ratingsIterator.hasNext()) {
                alreadyRatedItems.add(((Vector.Element)ratingsIterator.next()).index());
            }
            this.M.forEachPair((IntObjectProcedure)new IntObjectProcedure<Vector>(){

                public boolean apply(int itemID, Vector itemFeatures) {
                    if (!alreadyRatedItems.contains(itemID)) {
                        double predictedRating = ((Vector)PredictionMapper.this.U.get(userID)).dot(itemFeatures);
                        topKItems.offer(new GenericRecommendedItem(itemID, (float)predictedRating));
                    }
                    return true;
                }
            });
            ArrayList<RecommendedItem> recommendedItems = Lists.newArrayListWithExpectedSize(this.recommendationsPerUser);
            for (RecommendedItem topItem : topKItems.retrieve()) {
                recommendedItems.add(new GenericRecommendedItem(topItem.getItemID(), Math.min(topItem.getValue(), this.maxRating)));
            }
            if (!topKItems.isEmpty()) {
                ctx.write((Object)userIDWritable, (Object)new RecommendedItemsWritable(recommendedItems));
            }
        }
    }
}

