/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.online.generation;

import java.util.concurrent.locks.Lock;
import net.myrrix.common.collection.FastByIDMap;
import net.myrrix.common.collection.FastIDSet;
import net.myrrix.online.generation.Generation;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GenerationLoader {
    private static final Logger log = LoggerFactory.getLogger(GenerationLoader.class);
    private final FastIDSet recentlyActiveUsers;
    private final FastIDSet recentlyActiveItems;
    private final Object lockForRecent;

    GenerationLoader(FastIDSet recentlyActiveUsers, FastIDSet recentlyActiveItems, Object lockForRecent) {
        this.recentlyActiveUsers = recentlyActiveUsers;
        this.recentlyActiveItems = recentlyActiveItems;
        this.lockForRecent = lockForRecent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadModel(Generation currentGeneration, FastByIDMap<float[]> newX, FastByIDMap<float[]> newY, FastByIDMap<FastIDSet> updatedKnownItemIDs, FastIDSet updatedItemTagIDs, FastIDSet updatedUserTagIDs) {
        GenerationLoader.updateTagIDs(currentGeneration.getItemTagIDs(), updatedItemTagIDs, currentGeneration.getXLock().writeLock());
        GenerationLoader.updateTagIDs(currentGeneration.getUserTagIDs(), updatedUserTagIDs, currentGeneration.getYLock().writeLock());
        GenerationLoader.updateMap(currentGeneration.getX(), newX, currentGeneration.getXLock().writeLock());
        GenerationLoader.updateMap(currentGeneration.getY(), newY, currentGeneration.getYLock().writeLock());
        if (updatedKnownItemIDs != null) {
            GenerationLoader.updateMap(currentGeneration.getKnownItemIDs(), updatedKnownItemIDs, currentGeneration.getKnownItemLock().writeLock());
        }
        FastIDSet updatedXKeys = GenerationLoader.keysToSet(newX);
        FastIDSet updatedYKeys = GenerationLoader.keysToSet(newY);
        FastIDSet updatedUserIDsForKnownItems = updatedKnownItemIDs == null ? null : GenerationLoader.keysToSet(updatedKnownItemIDs);
        Object object = this.lockForRecent;
        synchronized (object) {
            if (Boolean.parseBoolean(System.getProperty("model.removeNotUpdatedData", "true"))) {
                log.info("Pruning old entries...");
                GenerationLoader.removeNotUpdated(currentGeneration.getX().keySetIterator(), updatedXKeys, this.recentlyActiveUsers, currentGeneration.getXLock().writeLock());
                GenerationLoader.removeNotUpdated(currentGeneration.getY().keySetIterator(), updatedYKeys, this.recentlyActiveItems, currentGeneration.getYLock().writeLock());
                if (updatedUserIDsForKnownItems != null && currentGeneration.getKnownItemIDs() != null) {
                    GenerationLoader.removeNotUpdated(currentGeneration.getKnownItemIDs().keySetIterator(), updatedUserIDsForKnownItems, this.recentlyActiveUsers, currentGeneration.getKnownItemLock().writeLock());
                }
                GenerationLoader.removeNotUpdated(currentGeneration.getItemTagIDs().iterator(), updatedItemTagIDs, this.recentlyActiveUsers, currentGeneration.getXLock().writeLock());
                GenerationLoader.removeNotUpdated(currentGeneration.getUserTagIDs().iterator(), updatedUserTagIDs, this.recentlyActiveItems, currentGeneration.getYLock().writeLock());
            }
            this.recentlyActiveUsers.clear();
            this.recentlyActiveItems.clear();
        }
        log.info("Recomputing generation state...");
        currentGeneration.recomputeState();
        log.info("All model elements loaded, {} users and {} items", (Object)currentGeneration.getNumUsers(), (Object)currentGeneration.getNumItems());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateTagIDs(FastIDSet currentTagIDs, FastIDSet updatedTagIDs, Lock writeLock) {
        writeLock.lock();
        try {
            currentTagIDs.addAll(updatedTagIDs);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void updateMap(FastByIDMap<T> knownItemIDs, FastByIDMap<T> updated, Lock writeLock) {
        writeLock.lock();
        try {
            for (FastByIDMap.MapEntry<T> entry : updated.entrySet()) {
                knownItemIDs.put(entry.getKey(), entry.getValue());
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    private static FastIDSet keysToSet(FastByIDMap<?> map) {
        FastIDSet result = new FastIDSet(map.size(), 1.25f);
        LongPrimitiveIterator it = map.keySetIterator();
        while (it.hasNext()) {
            result.add(it.nextLong());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeNotUpdated(LongPrimitiveIterator it, FastIDSet updated, FastIDSet recentlyActive, Lock writeLock) {
        writeLock.lock();
        try {
            while (it.hasNext()) {
                long id = it.nextLong();
                if (updated.contains(id) || recentlyActive.contains(id)) continue;
                it.remove();
            }
        }
        finally {
            writeLock.unlock();
        }
    }
}

